#' This function extracts the results of simulation.
#' @param x is an object generated by `SimulateLobsterMovement` function.
#' @param mls is the minimum legal size(mls) in mm. The default is 82.5 mm.
#' @return Returns the followings for each replicate: the number of lobsters caught,
#' legal catch weight (bigger than mls), total catch weight and length of time to reach maximum catch.
#' @export
GetSimOutput = function(x,mls=82.5){

  time.to.max <- list()
  max.catch   <- list()
  legwts      <- list()
  totwts      <- list()
  for( i in 1:length(x) ){
    time.to.max[[i]] = apply(x[[i]]$traps, 2, which.max)
    max.catch[[i]]   = apply(x[[i]]$traps, 2, max)

        legwtpertrap =  c()
        wtpertrap = c()
          s = x[[i]]$lobSize
          s = s[nrow(s),]
          j= length(s)
          for(k in 1:j){
                l = s[k]
                l = na.omit(as.numeric(unlist(strsplit(l[[1]],"-CL"))))
                n = which(l>mls)
                wtpertrap = c(wtpertrap,sum(lobLW(l)))
                legwtpertrap = c(legwtpertrap,sum(lobLW(l[n])))
              }
        legwts[[i]] = legwtpertrap
        totwts[[i]] = wtpertrap
  }

  time.to.max = as.data.frame(do.call(rbind,time.to.max))
  max.catch   = as.data.frame(do.call(rbind,max.catch))
  legwts      = as.data.frame(do.call(rbind,legwts))
  totwts      = as.data.frame(do.call(rbind,totwts))

  names(legwts) = names(totwts) = names(time.to.max)

  return( list(TimeToMax = time.to.max, MaxCatch = max.catch, LegalCatchWt = legwts, TotalCatchWt = totwts ) )
}
