% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaudermanModelling.R
\name{getGeneralizedGaudermanDataFrame}
\alias{getGeneralizedGaudermanDataFrame}
\title{Create Peak Matrices for Generalized 'Gauderman' linear mixed effect regression (LMER) Model with parameterized Times}
\usage{
getGeneralizedGaudermanDataFrame(
  peakmatrix,
  sampleIds,
  classes,
  center,
  timeperiod,
  gaudermanRange,
  k
)
}
\arguments{
\item{peakmatrix}{Peak matrix to be converted.}

\item{sampleIds}{Ids of samples in the matrix}

\item{classes}{Classes of samples}

\item{center}{Time point that corresponds to the center time t0. The algorithm will test whether there is a significant difference between the groups at this point.}

\item{timeperiod}{defines the time period or segment, in the spline to be tested. Note, a 3 break point spline has 4 segments.}

\item{gaudermanRange}{range to be tested for a significant difference between the groups.}

\item{k}{break points for the generalized 'Gauderman' spline model.}
}
\value{
Return the new peak matrix data frame for this peak.
}
\description{
Create Peak Matrices for Generalized 'Gauderman' linear mixed effect regression (LMER) Model with parameterized Times
}
