% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{limno_palette}
\alias{limno_palette}
\title{A Limnology palette generator}
\usage{
limno_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette. Choices are:
\code{IowaSummer}, \code{PeriFA},  \code{Bloom1},
\code{Bloom2}, \code{SuperIce},  \code{FlatheadRocks}, \code{ShelburnePond},
\code{WetSoil},\code{OrdRiver}}

\item{n}{Number of colors desired. All color
schemes are derived from photos provided by contributors to this
\href{https://twitter.com/SwampThingPaul/status/1301889771057356801?s=20}{twitter thread}.
If omitted, uses all colours.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.
@importFrom graphics rgb rect par image text}
}
\value{
A vector of colours.
}
\description{
These are a handful of color palettes inspired by lakes, rivers, streams and wetlands. .
}
\examples{
limno_palette("IowaSummer")
limno_palette("Bloom2")
limno_palette("PeriFA",10,"continuous")
}
\keyword{colors}
