% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeItems.R
\name{makeItems}
\alias{makeItems}
\title{Synthesise rating-scale item data with given first and second moments and a
predefined correlation matrix}
\usage{
makeItems(n, means, sds, lowerbound, upperbound, cormatrix)
}
\arguments{
\item{n}{(positive, int) sample-size - number of observations}

\item{means}{(real) target means: a vector of length k
of mean values for each scale item}

\item{sds}{(positive, real) target standard deviations: a vector of length k
of standard deviation values for each scale item}

\item{lowerbound}{(positive, int) a vector of length k
(same as rows & columns of correlation matrix) of values for lower bound
of each scale item (e.g. '1' for a 1-5 rating scale)}

\item{upperbound}{(positive, int) a vector of length k
(same as rows & columns of correlation matrix) of values for upper bound
of each scale item (e.g. '5' for a 1-5 rating scale)}

\item{cormatrix}{(real, matrix) the target correlation matrix:
a square symmetric positive-semi-definite matrix of values ranging
between -1 and +1, and '1' in the diagonal.}
}
\value{
a dataframe of rating-scale values
}
\description{
\code{makeItems()} generates a dataframe of random discrete
values so the data replicate a rating scale,
and are correlated close to a predefined correlation matrix.

\code{makeItems()} is being deprecated.
Use the \code{makeScales()} function instead.

\code{makeItems()} is wrapper function for:
\itemize{
\item \code{\link[=lfast]{lfast()}}, generates a dataframe that best fits the desired
moments, and
\item \code{\link[=lcor]{lcor()}}, which rearranges values in each column of the dataframe
so they closely match the desired correlation matrix.
}
}
\examples{

## define parameters

n <- 16
dfMeans <- c(2.5, 3.0, 3.0, 3.5)
dfSds <- c(1.0, 1.0, 1.5, 0.75)
lowerbound <- rep(1, 4)
upperbound <- rep(5, 4)

corMat <- matrix(
  c(
    1.00, 0.30, 0.40, 0.60,
    0.30, 1.00, 0.50, 0.70,
    0.40, 0.50, 1.00, 0.80,
    0.60, 0.70, 0.80, 1.00
  ),
  nrow = 4, ncol = 4
)

item_names <- c("Q1", "Q2", "Q3", "Q4")
rownames(corMat) <- item_names
colnames(corMat) <- item_names

## apply function

df <- makeItems(
  n = n, means = dfMeans, sds = dfSds,
  lowerbound = lowerbound, upperbound = upperbound, cormatrix = corMat
)

## test function

str(df)

# means
apply(df, 2, mean) |> round(3)

# standard deviations
apply(df, 2, sd) |> round(3)

# correlations
cor(df) |> round(3)

}
