% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_Datetime.R
\name{aggregate_Datetime}
\alias{aggregate_Datetime}
\title{Aggregate Datetime data}
\usage{
aggregate_Datetime(
  dataset,
  unit = "dominant.epoch",
  Datetime.colname = Datetime,
  type = c("round", "floor", "ceiling"),
  numeric.handler = mean,
  character.handler = function(x) names(which.max(table(x, useNA = "ifany"))),
  logical.handler = function(x) mean(x) >= 0.5,
  factor.handler = function(x) factor(names(which.max(table(x, useNA = "ifany")))),
  datetime.handler = mean,
  duration.handler = function(x) lubridate::duration(mean(x)),
  time.handler = function(x) hms::as_hms(mean(x)),
  ...
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the
\code{Datetime.colname}.}

\item{unit}{Unit of binning. See \code{\link[lubridate:round_date]{lubridate::round_date()}} for examples. The
default is \code{"dominant.epoch"}, which means everything will be aggregated to
the most common interval. This is especially useful for slightly irregular
data, but can be computationally expensive. \code{"none"} will not aggregate the
data at all.}

\item{Datetime.colname}{column name that contains the datetime. Defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}. Expects a \code{symbol}. Needs to be part of the \code{dataset}. Must
be of type \code{POSIXct}.}

\item{type}{One of \code{"round"}(the default), \code{"ceiling"} or \code{"floor"}. Setting
chooses the relevant function from \pkg{lubridate}.}

\item{numeric.handler, character.handler, logical.handler, factor.handler, datetime.handler, duration.handler, time.handler}{functions that handle the respective data types. The default handlers
calculate the \code{mean} or \code{median} for \code{numeric}, \code{POSIXct}, \code{duration}, and
\code{hms}, and the \code{mode} for \code{character}, \code{factor} and \code{logical} types.}

\item{...}{arguments given over to \code{\link[dplyr:summarise]{dplyr::summarize()}} to handle columns
that do not fall into one of the categories above. Be careful with partial
matching of argument names. E.g., creating a new column \code{n}, without having
changed the default for \code{numeric.handler} will match \code{n} to that argument.
You can avoid this be either explicitly supplying the \code{numeric.handler}
argument (using the default again), or you change the variable name, e.g,
to \code{n.}, which avoids the partial matching.}
}
\value{
A \code{tibble} with aggregated \code{Datetime} data. Usually the number of
rows will be smaller than the input \code{dataset}. If the handler arguments
capture all column types, the number of columns will be the same as in the
input \code{dataset}.
}
\description{
Condenses a \code{dataset} by aggregating the data to a given (shorter) interval
\code{unit}. \code{\link[=aggregate_Datetime]{aggregate_Datetime()}} is opinionated in the sense that it sets
default handlers for each data type of \code{numeric}, \code{character}, \code{logical},
\code{factor}, \code{duration}, \code{time}, and \code{datetime}. These can be overwritten by the
user. Columns that do not fall into one of these categories need to be
handled individually by the user (\code{...} argument) or will be removed during
aggregation. If no unit is specified the data will simply be aggregated to
the most common interval (\code{dominant.epoch}), which is most often not an
aggregation but a rounding.)
}
\details{
Summary values for type \code{POSIXct} are calculated as the mean, which can be
nonsensical at times (e.g., the mean of Day1 18:00 and Day2 18:00, is Day2
6:00, which can be the desired result, but if the focus is on time, rather
then on datetime, it is recommended that values are converted to times via
\code{\link[hms:hms]{hms::as_hms()}} before applying the function (the mean of 18:00 and 18:00 is
still 18:00, not 6:00).
}
\examples{
#dominant epoch without aggregation
sample.data.environment \%>\%
 dominant_epoch()

#dominant epoch with 5 minute aggregation
sample.data.environment \%>\%
 aggregate_Datetime(unit = "5 mins") \%>\%
 dominant_epoch()

#dominant epoch with 1 day aggregation
sample.data.environment \%>\%
 aggregate_Datetime(unit = "1 day") \%>\%
 dominant_epoch()
}
