% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.helioSchedule.R
\name{write.helioSchedule}
\alias{write.helioSchedule}
\title{Write the schedule to file that Heliospectra can parse}
\usage{
write.helioSchedule(regime_matrix, filename, format = c("csv", "json"))
}
\arguments{
\item{regime_matrix}{Matrix containing light regime, as generated by makeRegime}

\item{filename}{Character. Filename to export to}

\item{format}{Character. Which format to export to? csv or json. Use extensions '.csv' or '.txt'}
}
\value{
Heliospectra schedule file in either the csv or json format
}
\description{
Writes to json or csv format
}
\examples{
tempcsv_name = tempfile(fileext='.csv')
write.helioSchedule(LightFitR::example_regime, tempcsv_name, format='csv')

temptxt_name = tempfile(fileext='.txt')
write.helioSchedule(LightFitR::example_regime, temptxt_name, format='json')

}
