% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resmerge.ij.r
\name{resmerge.ij}
\alias{resmerge.ij}
\title{File management}
\usage{
resmerge.ij(path, prefix = "\\\\.|-")
}
\arguments{
\item{path}{Path to the target directory}

\item{prefix}{Regular expression to manage file names}
}
\value{
A data frame of total leaf area for each sample

\item{sample}{Name of sample}

\item{total.leaf.area}{Total leaf area of the sample (cm2)}
}
\description{
File management function. The output file contains sample names in the first column and total leaf area (cm2) of the sample (e.g., one individual plant or one ramet) in the second column.
}
\examples{
#prepare example files
data(leafdata)
tf <- paste(tempdir(),"/",sep="")
for (i in 1:7){
	write.table(leafdata[[i]],paste(tf,names(leafdata)[i],sep=""),sep="\\t")
}

#list of files
list.files(tf)

#combine multiple tab-delimited text files with a leaf area value
#(one text file for each original JPEG image file) that share the same
#filename 'prefix', defined as the part of the filename preceding the first
#hyphen (-) or period (.).
resmerge.ij(tf)

#combine multiple tab-delimited text files with a leaf area value
#(one text file for each original JPEG image file) that share the same
#filename 'prefix', defined as the part of the filename preceding the first
#'.txt'.
resmerge.ij(tf, prefix = ".txt")

unlink(list.files(tf))
}
\author{
Masatoshi Katabuchi \email{mattocci27@gmail.com}
}
