#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double r (double x) {  // reminder. 
	return( x-floor(x) ); 
}  

double w (double x) {  // wrap-around function. 
	return( x-floor(x+1./2.) ); 
}

int min(int x, int y) {
	return (x < y) ? x : y ;
}

double fmin(double x, double y) {
	return (x < y) ? x : y ;
}

int imods (long long x, long long z) {  // Find reminder of x divided by z.
	return x-z*(long long)floor((x+0.0001)/z); 
}

int iround (double a, double b) {  // Find rounding of a/b. 
	return (int)round(a/b); 
}

void EuclideanAlgorithm (long long a,long long b,long long* xy) {  // Find (x,y) such that xa+yb=1. 
	if(b==1) { 
		xy[0] = 1; 
		xy[1] = -a+1; 
		return;
	}
	long long u = floor((a+0.0001)/b); 
	long long v = a-u*b;
	long long z[2];
//printf("\nEuclidean: (%d, %d) (%d, %d)\n",a,b,u,v);
	EuclideanAlgorithm(b,v,z); 
	xy[0] = z[1];
	xy[1] = z[0]-u*z[1]; 
	return; 
}

void sv2 (int n, int* vbar, int* sv) {  // Find the shortest vector of the two-dimensional lattice that are generated by vbar. 
	int b1[2]; b1[0] = vbar[0]; b1[1] = vbar[1]; 
	int b2[2]; b2[0] = 0; b2[1] = n; 
//printf("\nsv2: (%d, %d) (%d, %d)\n",b1[0],b1[1],b2[0],b2[1]);
	int coef = iround((double)b1[0]*b2[0]+(double)b1[1]*b2[1],(double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
	b2[0] = b2[0] - coef*b1[0];
	b2[1] = b2[1] - coef*b1[1];
//printf("\nsv2: %d; (%d, %d) (%d, %d)\n",coef,b1[0],b1[1],b2[0],b2[1]);
	int temp1[2],temp2[2]; 
	while((double)b2[0]*b2[0]+(double)b2[1]*b2[1]<(double)b1[0]*b1[0]+(double)b1[1]*b1[1]) {
		temp1[0] = b1[0]; temp1[1] = b1[1]; 
		temp2[0] = b2[0]; temp2[1] = b2[1];
		b1[0] = temp2[0]; b1[1] = temp2[1];
		b2[0] = temp1[0]; b2[1] = temp1[1];
		coef = iround((double)b1[0]*b2[0]+(double)b1[1]*b2[1],(double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
		b2[0] = b2[0] - coef*b1[0];
		b2[1] = b2[1] - coef*b1[1];
//printf("\nsv2: %d; (%d, %d) (%d, %d)\n",coef,b1[0],b1[1],b2[0],b2[1]);
	}
	sv[0] = b1[0]; sv[1] = b1[1];
	return; 
}


void WSL_c(int* n_, int* d_, int* v, double* c) {
	int n = *n_;
	int d = *d_;
	double mindist2 = pow(d,2); 
	int i,k; 
	double dist2; 
	for(i=1;i<n;i++) { 
		dist2 = 0; 
		for(k=0;k<d;k++) dist2 += pow( w((double)v[k]*i/n), 2 ); 
		mindist2 = fmin( mindist2, dist2 ); 
	}
	*c = 1/sqrt(mindist2); 
	return;
}

void WPL_c(int* n_, int* d_, int* v, double* c) {
	int n = *n_;
	int d = *d_;
	int i,k;
	double sumdiscr = 0; 
	double prod;
	for(i=1;i<n;i++) {
		prod = 1;
		for(k=0;k<d;k++) prod *= pow( w((double)v[k]*i/n), -2 ); 
		sumdiscr += prod; 
	}
	*c = pow(sumdiscr/(n-1),1./d);
	return;
}

void WDL_c(int* n_, int* d_, int* v, double* c) {
	int n = *n_;
	int d = *d_;
	int i,k; 
	double sumdiscr = 0;
	double prod;
	for(i=1;i<=n;i++) {
		prod = 1;
		for(k=0;k<d;k++) prod *= 1.5 - r((double)v[k]*i/n) + pow(r((double)v[k]*i/n),2); 
		sumdiscr += prod; 
	}
	*c = sqrt( sumdiscr/n - pow(4./3.,d) ); 
	return;
}


void WSL2_c(int* n_, int* v, double* c) {
	int n = *n_;
	
	int vbar[2]; 
	vbar[0] = v[0]; vbar[1] = v[1];
	if(vbar[0]<0) { vbar[0] = -vbar[0]; vbar[1] = -vbar[1]; }
	long long xy[2]; 
	if(vbar[0]!=1) { 
		vbar[0] = 1;
		EuclideanAlgorithm(n,v[0],xy);
		vbar[1] = imods((long long)v[1]*xy[1],n); 
	}
//printf("\nWSL2:vbar: (%d %d)\n",vbar[0],vbar[1]); 
	int thesv[2]; 
	sv2(n,vbar,thesv);
//printf("\nWSL2:sv2: (%d %d)\n",thesv[0],thesv[1]); 
	*c = n/sqrt(pow((double)thesv[0],2)+pow((double)thesv[1],2));
	return;
}

void WFL2_c(int* n_, int* v, double* c) {
	int n = *n_;
	
	int vbar[2]; 
	vbar[0] = v[0]; vbar[1] = v[1];
	if(vbar[0]<0) { vbar[0] = -vbar[0]; vbar[1] = -vbar[1]; }
	long long xy[2]; 
	if(vbar[0]!=1) { 
		vbar[0] = 1;
		EuclideanAlgorithm(n,v[0],xy);
		vbar[1] = imods((long long)v[1]*xy[1],n); 
	}
	
	int b1[2],b2[2]; 
	b1[0] = vbar[0]; b1[1] = vbar[1];
	b2[0] = 0; b2[1] = n; 
	int coef = iround((double)b1[0]*b2[0]+(double)b1[1]*b2[1],(double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
	b2[0] = b2[0] - coef*b1[0];
	b2[1] = b2[1] - coef*b1[1];
	int temp1[2],temp2[2]; 
	while((double)b2[0]*b2[0]+(double)b2[1]*b2[1]<(double)b1[0]*b1[0]+(double)b1[1]*b1[1]) {
		temp1[0] = b1[0]; temp1[1] = b1[1]; 
		temp2[0] = b2[0]; temp2[1] = b2[1];
		b1[0] = temp2[0]; b1[1] = temp2[1];
		b2[0] = temp1[0]; b2[1] = temp1[1];
		coef = iround((double)b1[0]*b2[0]+(double)b1[1]*b2[1],(double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
		b2[0] = b2[0] - coef*b1[0];
		b2[1] = b2[1] - coef*b1[1];
	}
	double they = ((double)b1[0]*b2[0]+(double)b1[1]*b2[1]) / ((double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
	double thez2 = ( pow(b2[0]-they*b1[0],2) + pow(b2[1]-they*b1[1],2) ) / ((double)b1[0]*b1[0]+(double)b1[1]*b1[1]);
	*c = sqrt( thez2 + pow(thez2-fabs(they)+pow(they,2),2) ) /2 /sqrt(thez2) *sqrt((double)b1[0]*b1[0]+(double)b1[1]*b1[1]) /n; 
	return;
}

void WDL2_c(int* n_, int* v, double* c) {
	int n = *n_;
	
	int vbar[2]; 
	vbar[0] = v[0]; vbar[1] = v[1];
	if(vbar[0]<0) { vbar[0] = -vbar[0]; vbar[1] = -vbar[1]; }
	long long xy[2]; 
	if(vbar[0]!=1) { 
		vbar[0] = 1;
		EuclideanAlgorithm(n,v[0],xy);
		vbar[1] = imods((long long)v[1]*xy[1],n); 
	}
	
	int a[2]; 
	sv2(n,vbar,a);
	int a1 = abs(a[0]); int a2 = abs(a[1]); 
	int j1 = 0; int j2 = 0; 
	int gam = 0; 
	double sumdiscr = 0;
	double u1, u2; 
	int tgam; 
	while(gam<n) {
		u1 = -.5-j1; u2 = -.5-j2; 
		tgam = min( ceil(((double)(j1+1)*n-0.0001)/a1), ceil(((double)(j2+1)*n-0.0001)/a2) ); 
		sumdiscr += ( (double)(tgam-1)*tgam*(2*tgam-1)*(3*pow(tgam,2)-3*tgam-1) - (double)(gam-1)*gam*(2*gam-1)*(3*pow(gam,2)-3*gam-1) )/30. *a1*a1*a2*a2/pow(n,4)
			+ ( pow(tgam-1,2)*pow(tgam,2) - pow(gam-1,2)*pow(gam,2) )/4 *2.*a1*a2*((double)a1*u2+(double)a2*u1)/pow(n,3) 
			+ ( (double)(tgam-1)*tgam*(2*tgam-1) - (double)(gam-1)*gam*(2*gam-1) )/6. * ( (double)a1*a1*u2*u2+a2*a2*u1*u1 +4.*a1*a2*u1*u2 +1.25*((double)a1*a1+(double)a2*a2) )/pow(n,2) 
			+ ( (double)(tgam-1)*tgam - (double)(gam-1)*gam )/2. * ( 2.*((double)a1*u2+(double)a2*u1)*u1*u2+2.5*((double)a1*u1+(double)a2*u2) )/n 
			+ (double)(tgam-gam) * (u1*u1+1.25)*(u2*u2+1.25); 
		if(tgam == ceil(((double)(j1+1)*n-0.0001)/a1))  j1 += 1; 
		if(tgam == ceil(((double)(j2+1)*n-0.0001)/a2))  j2 += 1; 
		gam = tgam; 
	}
	*c = sqrt( sumdiscr /n - pow(4./3.,2) ); 
	return;
}


double WSL2_cc(int n, int* v) {
	int vbar[2]; 
	vbar[0] = v[0]; vbar[1] = v[1];
	if(vbar[0]<0) { vbar[0] = -vbar[0]; vbar[1] = -vbar[1]; }
	long long xy[2]; 
	if(vbar[0]!=1) { 
		vbar[0] = 1;
		EuclideanAlgorithm(n,v[0],xy);
		vbar[1] = imods((long long)v[1]*xy[1],n); 
	}
//printf("\nWSL2:vbar: (%d %d)\n",vbar[0],vbar[1]); 
	int thesv[2]; 
	sv2(n,vbar,thesv);
//printf("\nWSL2:sv2: (%d %d)\n",thesv[0],thesv[1]); 
	return n/sqrt(pow((double)thesv[0],2)+pow((double)thesv[1],2));
}

double WFL2_cc(int n, int* v) {
	int vbar[2]; 
	vbar[0] = v[0]; vbar[1] = v[1];
	if(vbar[0]<0) { vbar[0] = -vbar[0]; vbar[1] = -vbar[1]; }
	long long xy[2]; 
	if(vbar[0]!=1) { 
		vbar[0] = 1;
		EuclideanAlgorithm(n,v[0],xy);
		vbar[1] = imods((long long)v[1]*xy[1],n); 
	}
	
	int b1[2],b2[2]; 
	b1[0] = vbar[0]; b1[1] = vbar[1];
	b2[0] = 0; b2[1] = n; 
	int coef = iround((double)b1[0]*b2[0]+(double)b1[1]*b2[1],(double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
	b2[0] = b2[0] - coef*b1[0];
	b2[1] = b2[1] - coef*b1[1];
	int temp1[2],temp2[2]; 
	while((double)b2[0]*b2[0]+(double)b2[1]*b2[1]<(double)b1[0]*b1[0]+(double)b1[1]*b1[1]) {
		temp1[0] = b1[0]; temp1[1] = b1[1]; 
		temp2[0] = b2[0]; temp2[1] = b2[1];
		b1[0] = temp2[0]; b1[1] = temp2[1];
		b2[0] = temp1[0]; b2[1] = temp1[1];
		coef = iround((double)b1[0]*b2[0]+(double)b1[1]*b2[1],(double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
		b2[0] = b2[0] - coef*b1[0];
		b2[1] = b2[1] - coef*b1[1];
	}
	double they = ((double)b1[0]*b2[0]+(double)b1[1]*b2[1]) / ((double)b1[0]*b1[0]+(double)b1[1]*b1[1]); 
	double thez2 = ( pow(b2[0]-they*b1[0],2) + pow(b2[1]-they*b1[1],2) ) / ((double)b1[0]*b1[0]+(double)b1[1]*b1[1]);
	return sqrt( thez2 + pow(thez2-fabs(they)+pow(they,2),2) ) /2 /sqrt(thez2) *sqrt((double)b1[0]*b1[0]+(double)b1[1]*b1[1]) /n; 
}

double WDL2_cc(int n, int* v) {
	int vbar[2]; 
	vbar[0] = v[0]; vbar[1] = v[1];
	if(vbar[0]<0) { vbar[0] = -vbar[0]; vbar[1] = -vbar[1]; }
	long long xy[2]; 
	if(vbar[0]!=1) { 
		vbar[0] = 1;
		EuclideanAlgorithm(n,v[0],xy);
		vbar[1] = imods((long long)v[1]*xy[1],n); 
	}
	
	int a[2]; 
	sv2(n,vbar,a);
	int a1 = abs(a[0]); int a2 = abs(a[1]); 
	int j1 = 0; int j2 = 0; 
	int gam = 0; 
	double sumdiscr = 0;
	double u1, u2; 
	int tgam; 
	while(gam<n) {
		u1 = -.5-j1; u2 = -.5-j2; 
		tgam = min( ceil(((double)(j1+1)*n-0.0001)/a1), ceil(((double)(j2+1)*n-0.0001)/a2) ); 
		sumdiscr += ( (double)(tgam-1)*tgam*(2*tgam-1)*(3*pow(tgam,2)-3*tgam-1) - (double)(gam-1)*gam*(2*gam-1)*(3*pow(gam,2)-3*gam-1) )/30. *a1*a1*a2*a2/pow(n,4)
			+ ( pow(tgam-1,2)*pow(tgam,2) - pow(gam-1,2)*pow(gam,2) )/4 *2.*a1*a2*((double)a1*u2+(double)a2*u1)/pow(n,3) 
			+ ( (double)(tgam-1)*tgam*(2*tgam-1) - (double)(gam-1)*gam*(2*gam-1) )/6. * ( (double)a1*a1*u2*u2+a2*a2*u1*u1 +4.*a1*a2*u1*u2 +1.25*((double)a1*a1+(double)a2*a2) )/pow(n,2) 
			+ ( (double)(tgam-1)*tgam - (double)(gam-1)*gam )/2. * ( 2.*((double)a1*u2+(double)a2*u1)*u1*u2+2.5*((double)a1*u1+(double)a2*u2) )/n 
			+ (double)(tgam-gam) * (u1*u1+1.25)*(u2*u2+1.25); 
		if(tgam == ceil(((double)(j1+1)*n-0.0001)/a1))  j1 += 1; 
		if(tgam == ceil(((double)(j2+1)*n-0.0001)/a2))  j2 += 1; 
		gam = tgam; 
	}
	return sqrt( sumdiscr /n - pow(4./3.,2) ); 
}


void bWSL_c(int* n_, int* d_, int* v, double* c) {
	int n = *n_; 
	int d = *d_;
	double thesum = 0;
	int j,k; 
	int thev[2]; 
// printf("\nbWSL: %f\n",thesum); 
	for(j=0;j<d-1;j++) {
		thev[0] = v[j]; 
		for(k=j+1;k<d;k++) {
			thev[1] = v[k]; 
			thesum += WSL2_cc(n,thev);
// printf("\nbWSL: (%d %d), %f\n",thev[0],thev[1],thesum); 
		}
	}
	*c = thesum/d/(d-1)*2 ; 
	return;
}

void bWFL_c(int* n_, int* d_, int* v, double* c) {
	int n = *n_; 
	int d = *d_;
	double thesum = 0;
	int j,k; 
	int thev[2]; 
	for(j=0;j<d-1;j++) {
		thev[0] = v[j]; 
		for(k=j+1;k<d;k++) {
			thev[1] = v[k]; 
			thesum += WFL2_cc(n,thev);
		}
	}
	*c = thesum/d/(d-1)*2 ; 
	return;
}

void bWDL_c(int* n_, int* d_, int* v, double* c) {
	int n = *n_; 
	int d = *d_;
	double thesum = 0;
	int j,k; 
	int thev[2]; 
	for(j=0;j<d-1;j++) {
		thev[0] = v[j]; 
		for(k=j+1;k<d;k++) {
			thev[1] = v[k]; 
			thesum += WDL2_cc(n,thev);
		}
	}
	*c = thesum/d/(d-1)*2 ; 
	return;
}

