% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_normal.R
\name{log_normal_mu_one_way}
\alias{log_normal_mu_one_way}
\title{Test the equality of means of log normal distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
log_normal_mu_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of means of log normal distributions.
}
\details{
\itemize{
\item Null: All mus are equal. (mu1 = mu2 ... muk).
\item Alternative: At least one mu is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rlnorm(150, 1, 1)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
log_normal_mu_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rlnorm(50, 1, 1), rlnorm(50, 2, 1), rlnorm(50, 3, 1))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
log_normal_mu_one_way(x, fctr, .95)
}
