% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LBSPR_NLLabsel}
\alias{LBSPR_NLLabsel}
\title{LBSPR Optimization function for age-based selectivity model}
\usage{
LBSPR_NLLabsel(
  starts,
  x,
  P,
  LMids,
  LBins,
  LDat,
  MK,
  Linf,
  FecB,
  L50,
  L95,
  maxsd,
  CVLinf,
  Nage,
  usePen
)
}
\arguments{
\item{starts}{a vector of starting parameters, relative SL50 (SL50/Linf), deltaSL (SL95-SL50)/Linf, and F/M (in log space)}

\item{x}{vector of relative ages}

\item{P}{numeric value indicating proportion of cohort remaining at maximum age}

\item{LMids}{a vector of the midpoints of the length classes}

\item{LBins}{a vector of length classes}

\item{LDat}{a vector of lenght frequencies. Must be same length as LMids}

\item{MK}{the M/K value}

\item{Linf}{the Linf value for the population as a hole}

\item{FecB}{exponent of the length-fecundity relationship}

\item{L50}{length at 50 per cent maturity}

\item{L95}{length at 95 per cent maturity}

\item{maxsd}{numeric value - maximum number of standard deviations of length-at-age dist}

\item{CVLinf}{CV of length-at-age}

\item{Nage}{number of pseudo age-classes}

\item{usePen}{logical to use penalty for extreme estimates of selectivity}
}
\value{
negative log-likelihood value
}
\description{
Internal optimization function
}
\author{
A. Hordyk
}
