% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_preprocessing.R
\name{load_mesh_terms_from_pubmed}
\alias{load_mesh_terms_from_pubmed}
\title{Load terms from MeSH using PubMed search}
\usage{
load_mesh_terms_from_pubmed(
  mesh_queries,
  max_results = 50,
  min_term_length = 3,
  sanitize = TRUE
)
}
\arguments{
\item{mesh_queries}{A named list of MeSH queries for different categories.}

\item{max_results}{Maximum number of results to retrieve per query.}

\item{min_term_length}{Minimum length of terms to include.}

\item{sanitize}{Logical. If TRUE, sanitizes the extracted terms.}
}
\value{
A data frame containing the combined dictionary with extracted terms.
}
\description{
This function enhances the MeSH dictionary by extracting additional terms
from PubMed search results using MeSH queries.
}
\keyword{internal}
