#' Digitised data corresponding to Figure 2 of Carpenter and Williams (1995)
#'
#' @format ## `carpenter_williams_1995`
#' A dataframe of 20014 reaction times for participant a and 22518 reaction
#' times for participant b
#' \describe{
#'   \item{participant}{Participant "name", either "a" or "b"}
#'   \item{condition}{Prior percentage probability of the target being in the
#'   location of the eye movement (p05, p10, p25, p50, p75, p90, or p95)}
#'   \item{time}{Saccadic latency in ms}
#' }
#' @source Carpenter, R. H., & Williams, M. L. L. (1995). Neural computation
#' of log likelihood in control of saccadic eye movements. Nature,
#' 377(6544), 59-62.
"carpenter_williams_1995"

#' Digitised data corresponding to Figure 2 of Reddi, Asrress, and Carpenter,
#' 2003.
#'
#' @format ## `reddi_asrress_carpenter_2003`
#' A dataframe of 1600 reaction times for participant J
#' \describe{
#'   \item{participant}{Participant "name", equal to "J"}
#'   \item{condition}{Different degrees of coherence of the kinematograms shown
#'   as stimuli, (64%, 32%, 16%, 8%: S, low-urgency–slow and
#'   accurate–conditions)}
#'   \item{time}{Saccadic latency in ms}
#' }
#' @source Reddi, B. A., Asrress, K. N., & Carpenter, R. H. (2003). Accuracy,
#' information, and response time in a saccadic decision task. Journal of
#' Neurophysiology, 90(5), 3538-3546.
#'
"reddi_asrress_carpenter_2003"
