% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centLOC.R, R/summary.R
\name{L1centLOC}
\alias{L1centLOC}
\alias{L1presLOC}
\alias{L1centLOC.igraph}
\alias{L1centLOC.matrix}
\alias{print.L1centLOC}
\alias{plot.L1centLOC}
\alias{summary.L1centLOC}
\title{Local L1 Centrality/Prestige}
\usage{
L1centLOC(g, eta, alpha, mode, weight_transform)

\method{L1centLOC}{igraph}(
  g,
  eta = NULL,
  alpha,
  mode = c("centrality", "prestige"),
  weight_transform = NULL
)

\method{L1centLOC}{matrix}(
  g,
  eta = NULL,
  alpha,
  mode = c("centrality", "prestige"),
  weight_transform = NULL
)

\method{print}{L1centLOC}(x, ...)

\method{plot}{L1centLOC}(x, y = NULL, add = FALSE, threshold = NULL, ...)

\method{summary}{L1centLOC}(object, ...)
}
\arguments{
\item{g}{An \code{igraph} graph object or a distance matrix. The graph must
be connected. For a directed graph, it must be strongly connected.
Equivalently, all entries of the distance matrix must be finite. Here, the
\ifelse{html}{\out{(<i>i,j</i>)}}{\eqn{(i,j)}} component of the distance
matrix is the geodesic distance from the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th vertex to the
\ifelse{html}{\out{<i>j</i>}}{\eqn{j}}th vertex.}

\item{eta}{An optional nonnegative multiplicity (weight) vector for (vertex)
weighted networks. The sum of its components must be positive. If set to
\code{NULL} (the default), all vertices will have the same positive weight
(multiplicity) of 1, i.e., \code{g} is treated as a vertex unweighted graph. The
length of the \code{eta} must be equivalent to the number of vertices.}

\item{alpha}{A number or a numeric vector of locality levels. Values
must be between 0 and 1.}

\item{mode}{A character string. For an undirected graph, either choice gives
the same result.
\itemize{
\item \code{centrality} (the default): \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality (prominence of each vertex in terms of \emph{making} a choice) is
used for analysis.
\item \code{prestige}: \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
prestige (prominence of each vertex in terms of \emph{receiving} a choice)
is used for analysis.
}}

\item{weight_transform}{An optional function to transform the edge weights
when \code{g} is an \code{igraph} object and an edge weight attribute exists. This
argument is ignored when \code{g} is a distance matrix.}

\item{x}{An \code{L1centLOC} object, obtained as a result of the function
\code{L1centLOC()}.}

\item{...}{Further arguments passed to or from other methods.}

\item{y}{An optional argument providing the coordinates for a scatter plot.
It could be an object of class \code{L1cent} or \code{L1centLOC}, or a
numeric vector.}

\item{add}{A logical value. This argument is considered only when drawing a Lorenz curve.
\itemize{
\item \code{TRUE}: add the Lorenz curve to an already existing plot.
\item \code{FALSE} (the default): draw the Lorenz curve to a new graphic device.
}}

\item{threshold}{A number between 0 and 1. Vertices that have their maximum
and minimum local \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
prominence value difference above the \code{threshold} are indicated in
colored lines.}

\item{object}{An \code{L1centLOC} object, obtained as a result of the function
\code{L1centLOC()}.}
}
\value{
\code{L1centLOC()} returns an object of class \code{L1centLOC}. It is
a list of numeric vectors. The length of the list is equivalent to the
length of \code{alpha}, and the names of the list are the values of
\code{alpha}. Each component of the list is a numeric vector whose length
is equivalent to the number of vertices in the graph \code{g}.
Specifically, the \code{i}th component of the list is a vector of local
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality at level
\code{alpha[i]} for each vertex (if \code{mode = "centrality"}) or local
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prestige at level
\code{alpha[i]} for each vertex (if \code{mode = "prestige"}).

\code{print.L1centLOC()} prints local
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality or local
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prestige values at
each locality level \code{alpha} and returns them invisibly.

\code{plot.L1centLOC()} draws a following plot.
\itemize{
\item \code{y} is not supplied and \code{alpha} is of length one: A Lorenz curve (the group heterogeneity plot)
and returns an invisible copy of a Gini coefficient (the group heterogeneity
index). \code{threshold} is ignored.
\item \code{y} is supplied and \code{alpha} is of length one: A scatter plot of
\code{x} versus \code{y}. \code{threshold} is ignored.
\item \code{alpha}'s length is larger than one: A plot of \code{alpha} versus
local \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prominence
values (in a uniform margin) for each vertex. If \code{threshold} is set,
vertices that have their maximum
and minimum local \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
prominence value difference above the \code{threshold} are indicated in
colored lines. \code{y} is ignored.
}

\code{summary.L1centLOC()} returns an object of class \code{table}.
It is a summary of the prominence values with the five-number summary,
mean, and the Gini coefficient, at each level of \code{alpha}.
}
\description{
Computes local \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality or local \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
prestige at each \code{alpha} level for every vertex. For undirected graphs,
the two measures are identical.
}
\details{
Suppose that the given graph has \ifelse{html}{\out{<i>n</i>}}{\eqn{n}}
vertices. We choose about \eqn{n\alpha} vertices
(\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality- or
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prestige-based
neighborhood) for each vertex (see \code{\link[=L1centNB]{L1centNB()}}), and compute the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality or
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prestige of the vertex
conditioned on these vertices, i.e., derive the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality or
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prestige locally. For
details, refer to Kang and Oh (2025a) for undirected graphs, and Kang and Oh
(2025b) for directed graphs.
}
\note{
The function is valid only for connected graphs. If the graph is directed, it
must be strongly connected.
}
\examples{
weight <- igraph::V(MCUmovie)$worldwidegross
MCUmovie_cent <- L1cent(MCUmovie, eta = weight)
MCUmovie_loc_cent <- L1centLOC(MCUmovie, eta = weight, alpha = 5/32)
plot(MCUmovie_cent, MCUmovie_loc_cent,
     main = "MCU movie network: global vs. local centrality")
}
\references{
S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
\emph{Journal of the American Statistical Association}, 1--13, 2025a.

S. Kang and H.-S. Oh.
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prominence measures
for directed graphs. \emph{The American Statistician}, 1--16, 2025b.
}
\seealso{
\code{\link[=L1cent]{L1cent()}} for
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality/prestige,
\code{\link[=L1centNB]{L1centNB()}} for \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality/prestige-based neighborhood.
}
