% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSEA.Heatmap.R
\name{KSEA.Heatmap}
\alias{KSEA.Heatmap}
\title{The KSEA App Analysis (KSEA Heatmap Only)}
\usage{
KSEA.Heatmap(score.list, sample.labels, stats, m.cutoff, p.cutoff,
  sample.cluster)
}
\arguments{
\item{score.list}{the data frame outputs from the KSEA.Scores() function, compiled in a list format}

\item{sample.labels}{a character vector of all the sample names for heatmap annotation; 
the names must be in the same order as the data in score.list;
please avoid long names, as they may get cropped in the final image}

\item{stats}{character string of either "p.value" or "FDR" indicating 
the data column to use for marking statistically significant scores}

\item{m.cutoff}{a numeric value between 0 and infinity indicating the min. # 
of substrates a kinase must have to be included in the heatmap}

\item{p.cutoff}{a numeric value between 0 and 1 indicating the p-value/FDR cutoff 
for indicating significant kinases in the heatmap}

\item{sample.cluster}{a binary input of TRUE or FALSE, indicating whether or not 
to perform hierarchical clustering of the sample columns}
}
\value{
exports a .png heatmap image highlighting the merged datasets; 
        heatmap was generated using the heatmap.2() function (gplots package);
        asterisks mark scores that met the statistical cutoff, as defined by p.cutoff;
        blue color indicates negative kinase score, and red indicates positive kinase score
}
\description{
Takes a list of the KSEA kinase score outputs from KSEA.Scores() 
and creates a merged heatmap (only applicable for multi-treatment studies)
}
\examples{
#The score.list input must be a list of the data frame outputs from KSEA.Scores() function
#KSEA.Scores.1, KSEA.Scores.2, and KSEA.Scores.3 are all 
#sample datasets provided within this package

KSEA.Heatmap(score.list=list(KSEA.Scores.1, KSEA.Scores.2, KSEA.Scores.3), 
             sample.labels=c("Tumor.A", "Tumor.B", "Tumor.C"), 
             stats="p.value", m.cutoff=3, p.cutoff=0.05, sample.cluster=TRUE)

}
\references{
Casado et al. (2013) Sci Signal. 6(268):rs6

Hornbeck et al. (2015) Nucleic Acids Res. 43:D512-20

Horn et al. (2014) Nature Methods 11(6):603-4
}
