% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kerPIQ.R
\name{kerPIQ}
\alias{kerPIQ}
\title{Product-type Inverse-Quadratic (PIQ) kernel computation}
\usage{
kerPIQ(gamma, z1, z2)
}
\arguments{
\item{gamma}{A number, the bandwidth parameter in the PIQ kernel.}

\item{z1}{A vector, the first input of the PIQ kernel.}

\item{z2}{A vector, the second input of the PIQ kernel.}
}
\value{
A number, the value of the PIQ kernel function.
}
\description{
Computing the values of Product-type Inverse-Quadratic (PIQ) kernel functions.
}
\details{
The Product-type Inverse-Quadratic (PIQ) kernel is defined as
k(z1,z2)=Prod_j(1/(1+gamma*(z1_j-z2_j)^2)).
}
\examples{
gamma=0.02
z1=c(3,1,3)
z2=c(8,1,9)
kerPIQ(gamma,z1,z2)

}
