% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{PBC}
\alias{PBC}
\title{PBC data}
\format{
\code{PBC}: A data frame of 312 individuals in long format with 1945 rows
and 21 variables.
}
\description{
Data from the Mayo Clinic trial in primary biliary cirrhosis (PBC) of the
liver. This dataset was obtained from the \strong{survival} package:
the variables \code{copper} and \code{trig} from \code{survival::pbc} were
merged into \code{survival::pbcseq} and several categorical variables were
re-coded.
}
\section{Survival outcome and id}{

\describe{
\item{id}{case number}
\item{futime}{number of days between registration and the earlier of death,
transplantation, or end of follow-up}
\item{status}{status at endpoint ("censored", "transplant" or "dead")}
}
}

\section{Baseline covariates}{

\describe{
\item{trt}{D-pen (D-penicillamine) vs  placebo}
\item{age}{in years}
\item{sex}{male or female}
\item{copper}{urine copper (\eqn{\mu}g/day)}
\item{trig}{triglycerides (mg/dl)}
}
}

\section{Time-varying covariates}{

\describe{
\item{day}{number of days between enrolment and this visit date; all
measurements below refer to this date}
\item{albumin}{serum albumin (mg/dl)}
\item{alk.phos}{alkaline phosphatase (U/liter)}
\item{ascites}{presence of ascites}
\item{ast}{aspartate aminotransferase (U/ml)}
\item{bili}{serum bilirubin (mg/dl)}
\item{chol}{serum cholesterol (mg/dl)}
\item{edema}{"no": no oedema,
"(un)treated": untreated or successfully treated 1 oedema,
"edema": oedema despite diuretic therapy}
\item{hepato}{presence of hepatomegaly (enlarged liver)}
\item{platelet}{platelet count}
\item{protime}{standardised blood clotting time}
\item{spiders}{blood vessel malformations in the skin}
\item{stage}{histologic stage of disease (4 levels)}
}
}

\examples{
 summary(PBC)

}
\keyword{datasets}
