% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASS2.R
\name{PASS2}
\alias{PASS2}
\title{Modelling Judgments of Frequency with PASS 2}
\usage{
PASS2(x, y, ..., sqc, att, n_output_units = "half", rdm_weights = F, noise = 0)
}
\arguments{
\item{x}{input handled by PASS 2. Only binary input is allowed.}

\item{y}{a second binary input handled by PASS 1. At least
two inputs are needed for the simulation.}

\item{...}{other binary inputs for modeling.}

\item{sqc}{sequence of the different objects. Each input gets
an ascending number. \code{x} gets the value \code{1},
\code{y} gets the value \code{2}, \code{...} gets the value
\code{3} and so on.
The argument \code{sqc = c(1, 2, 3, 2)} means: first
input \code{x} is processed, second input \code{y} is
processed followed by processing input number three and
fourth, th input \code{y} is used again.
So \code{sqc} contains the frequency information too.
In \code{c(1, 2, 3, 2)}, \code{x} and  the third input
are presented once. The input \code{y} is presented twice.}

\item{att}{attention is a vector with numeric values
between 0 and 1. \code{att} has the same length like
\code{sqc}, so each input processing have its own value
and PASS 1 can modulate attention by time or input.
If  \code{att} is exact one numeric value
(e.g. \code{ att = .1}), all inputs get the
same parameter of attention.}

\item{n_output_units}{number of output units as numeric value.
This must be between 1 and the maximum number of input units.
\code{n_output_units = 'half'} determines the half of the input
units.}

\item{rdm_weights}{a logical value indicating whether random
weights in the neural network are used or not. If
\code{rdm_weights = FALSE} all network connections are zero
at the beginning.}

\item{noise}{a proportion between 0 and 1 which determines
the number of random activated input units (higher numbers
indicate higher noise).}
}
\value{
\code{PASS2} returns the relative judgment of frequency
for each input.
}
\description{
Modelling Judgments of Frequency with PASS 2
}
\details{
PASS 2 uses a competitive learning algorithm, which
usually clusters the input as side effect. If weights are
equal, the winning unit is chosen randomly, because of this,
each simulation is slightly different.
\deqn{if an outputuni O_{i} losses:  \Delta w_{ij} = 0}{if
an outputunit Oi losses:  \Delta wij = 0}
\deqn{if an outputuni O_{i} wins:  \Delta w_{ij} = g_{w}
\frac{a_{i}}{\sum_{i}^{n}{a_{i}}} - g_{w}w_{ij}}{if
an outputunit Oi wins:  \Delta wij = gw * (ai / sum(ai)) -
gw*wij}
}
\examples{
o1 <- c(1, 0, 0, 0)
o2 <- c(0, 1, 0, 0)
o3 <- c(0, 0, 1, 0)
o4 <- c(0, 0, 0, 1)
PASS2(o1, o2, o3, o4,
      sqc = rep(1:4, 4:1), att = .1, n_output_units = 2,
      rdm_weights = FALSE, noise = 0)
}
\references{
Sedlmeier, P. (2002). Associative learning and
frequency judgements: The PASS model. In P. Sedlmeier,
T. Betsch (Eds.), \emph{Etc.: Frequency processing and cognition}
(pp. 137-152). New York: Oxford University Press.
}
