% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_Signal_2D_support.R
\name{pspline_fitter}
\alias{pspline_fitter}
\title{P-spline fitting algorithm for the GLM.}
\usage{
pspline_fitter(
  y,
  B,
  family = "gaussian",
  link = "identity",
  P,
  P_ridge = 0 * diag(ncol(B)),
  wts = 0 * y + 1,
  m_binomial = 0 * y + 1,
  r_gamma = 0 * y + 1
)
}
\arguments{
\item{y}{the glm response vector of length \code{m}.}

\item{B}{The effective P-spline regressors, e.g. \code{B} for B-splines, \code{Q=X \%*\% B} for PSR.}

\item{family}{the response distribution, e.g. \code{"gaussian", "binomial", "poisson", "Gamma"} distribution; quotes are needed
(default \code{family = "gaussian"}.)}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"};
quotes are needed (default \code{link = "identity"}).}

\item{P}{P-spline ("half") penalty matrix for data augmentation, such that \code{P'P = lambda D'D}.}

\item{P_ridge}{ridge ("half") penalty for data augmentation, usually \code{sqrt(lambda_r)*I} (default 0).}

\item{wts}{the weight vector of \code{length(y)}, separate from GLM weights.}

\item{m_binomial}{a vector of binomial trials having \code{length(y)}, when \code{family = "binomial"}.
Default is 1 vector.}

\item{r_gamma}{a vector of gamma shape parameters, when \code{family = "Gamma"}. Default is 1 vector.}
}
\value{
\item{coef}{the estimated P-spline coefficient regressor, using the effective regressors.}
\item{w}{\code{wts*w}, GLM weight vector times input weights of length m.}
\item{f}{the \code{lsfit} object using data augmentation to get P-spline coefficient estimates.}
\item{eta}{the linear predictor from \code{f}.}
}
\description{
\code{pspline_fitter} appies the method of scoring
to a variety of response distributions and link functions within
for P-spline fitting within the GLM framework.
}
