% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_configs.R
\docType{data}
\name{ogden2005}
\alias{ogden2005}
\title{Configuration for Ixodes scapularis population dynamics model from Ogden et
al. 2005}
\format{
A \code{\link{config}}
}
\usage{
ogden2005
}
\description{
This model configuration recreates the Ixodes scapularis (blacklegged tick)
population dynamics model from Ogden et al. 2005. This is a relatively
complete model of tick population dynamics, including the effects of both
temperature and the host community on tick life-stage transitions. We include
this configuration to show that our package can be used to recreate existing
models.
}
\details{
In this config, the population starts with 10000 questing adults. The
predictor data includes average temperature for each day, and density of
hosts over the model run. Here the host community is stable with 20 deer and
200 mice.
}
\examples{
data(ogden2005)
\dontrun{
output <- run(ogden2005)
graph_population_each_group(output)
}
}
\seealso{
Ogden et al. (2005) \doi{10.1016/j.ijpara.2004.12.013}
}
\keyword{datasets}
