% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_transition_functions.R
\name{feed_fun}
\alias{feed_fun}
\title{Probability of actively questing and then finding a host}
\usage{
feed_fun(x, y, a, pref, q, tmin, tmax)
}
\arguments{
\item{x}{Predictor 1 in transitions table. Numeric vector indicating host
density for each of the host species. Length should be equal to the number
of host species.}

\item{y}{Predictor 2 in transitions table. Numeric vector of length 1
indicating temperature.}

\item{a}{Parameter \code{a} in parameters table.}

\item{pref}{Parameters named \code{pref} in parameters table. Numeric vector of
length equal to the number of host species. Values are the preference for
ticks in a given transition for each host species.}

\item{q}{Parameter \code{q} in parameters table. Used in Briere function.}

\item{tmin}{Parameter \code{tmin} in parameters table. Indicates minimum
temperature at which ticks actively quest.}

\item{tmax}{Parameter \code{tmax} in parameters table. Indicates maximum
temperature at which ticks actively quest.}
}
\value{
Numeric vector of length 1
}
\description{
Probability of actively questing and then finding a host
}
\details{
Product of binomial and Briere functions
(prob of finding a host) * (prob of active questing)
}
\examples{
feed_fun(10, 30, .001, .1, .5, 20, 40)

}
