% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_transition_functions.R
\name{density_fun}
\alias{density_fun}
\title{Density dependent mortality}
\usage{
density_fun(x, y, a, b, c, pref)
}
\arguments{
\item{x}{Predictor 1 in transitions table. Numeric vector indicating host
density for each of the host species. Length should be equal to the number
of host species.}

\item{y}{Predictor 2 in transitions table. Number of feeding ticks in life
stages specified by predictor 2.}

\item{a}{Parameter \code{a} in parameters table.}

\item{b}{Parameter \code{b} in parameters table.}

\item{c}{Parameter \code{c} in parameters table.}

\item{pref}{Parameters named \code{pref} in parameters table. Numeric vector of
length equal to the number of host species. Values are the preference for
ticks in a given transition for each host species.}
}
\value{
Numeric vector of length 1, indicating mortality rate
}
\description{
Density dependent mortality
}
\examples{
density_fun(c(10, 20), 100, .1, .3, .2, c(.5, .8))

}
