% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape.R
\name{make_2d_Isingland_matrix}
\alias{make_2d_Isingland_matrix}
\title{Make a matrix of landscapes for multiple Ising networks}
\usage{
make_2d_Isingland_matrix(Ising_grid, transform = FALSE)
}
\arguments{
\item{Ising_grid}{Parameter values generated by \code{\link[=make_Ising_grid]{make_Ising_grid()}}.}

\item{transform}{By default, this function considers the Ising network
to use \code{-1} and \code{1} for two states. Set \code{transform = TRUE} if the Ising
network uses \code{0} and \code{1} for two states, \emph{which is often the case for the
Ising networks estimated using} \code{\link[IsingFit:isingfit]{IsingFit::IsingFit()}}.}
}
\value{
A \verb{2d_Isingland_matrix} object that contains the following
components:
\itemize{
\item \code{dist_raw},\code{dist} Two tibbles containing the probability
distribution and the potential values for different states.
\item \code{Nvar} The number of variables (nodes) in the Ising network.
}
}
\description{
Make multiple landscapes together for different parameters.
}
\examples{
Nvar <- 10
m <- rep(0, Nvar)
w <- matrix(0.1, Nvar, Nvar)
diag(w) <- 0
result4 <- make_Ising_grid(
all_thresholds(seq(-0.1, 0.1, 0.1), .f = `+`),
whole_weiadj(seq(0.5, 1.5, 0.5)),
m, w
) \%>\% make_2d_Isingland_matrix()
plot(result4)
}
