% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvm_3series.R
\name{cvm_3series}
\alias{cvm_3series}
\title{Cramer-von Mises Moebius statistics for testing independence between the innovations of 3 series of same length}
\usage{
cvm_3series(x, y, z, lag2, lag3)
}
\arguments{
\item{x}{Pseudo-observations (or residuals) of first series.}

\item{y}{Pseudo-observations (or residuals) of second series.}

\item{z}{Pseudo-observations (or residuals) of third series.}

\item{lag2}{Maximum number of lags around 0 for pairs of series.}

\item{lag3}{Maximum number of lags around 0 for the three series.}
}
\value{
\item{cvm}{Cramer-von Mises statistics for all lags and for all subsets}

\item{Wstat}{Sum of (unbiased) Cramer-von Mises statistics for all subsets}

\item{Fstat}{Combination of p-values of the Cramer-von Mises statistics}

\item{pvalue}{List of p-values for the cvm, Wstat, and Fstat}
}
\description{
This function computes the Cramer-von Mises statistics between x(t), y(t-l2), z(t-l3), for l2=-lag2,.., lag2, l3=-lag3,.., lag3,and also the combinations of these statistics.
}
\examples{
set.seed(1)
x0 = rnorm(100); y = rnorm(100); z = rnorm(100);

}
\references{
Duchesne, Ghoudi & Remillard  (2012). On Testing for independence between the innovations of several time series. CJS, vol. 40, 447-479.
}
