% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNN.R
\name{findNN}
\alias{findNN}
\title{Find the nearest neighbour (NN) given a cell and a group of cells;}
\usage{
findNN(cell, cellList, XY_LABELS = c("Cell.X.Position",
  "Cell.Y.Position"))
}
\arguments{
\item{cell}{An object cell}

\item{cellList}{A list of cell types to be calculated for}

\item{XY_LABELS}{x and y positions of the cell}
}
\value{
The Nearest Neibour Cell distance and calculate the distance
}
\description{
Find the nearest neighbour (NN) given a cell and a group of cells;
}
\examples{
Cell.X.Position=sample (1:100,1)
Cell.Y.Position=sample (1:100,1)
Tcell=data.frame(Cell.X.Position,Cell.Y.Position)
Cell.X.Position=sample(1:500,5,replace=TRUE)
Cell.Y.Position=sample(1:500,5,replace=TRUE)
Tumor.cells=data.frame(Cell.X.Position,Cell.Y.Position)
findNN(Tcell,Tumor.cells,XY_LABELS=c('Cell.X.Position', 'Cell.Y.Position'))
}
