% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cchart.S.R
\name{cchart.S}
\alias{cchart.S}
\title{S Control Chart.}
\usage{
cchart.S(x, type = "n", m = NULL)
}
\arguments{
\item{x}{The data to be plotted.}

\item{type}{A character string specifying the type of S control chart to be
plotted where "n" plots a S chart with normalized probability limits and "e"
plots a S chart with exact limits.}

\item{m}{The sample sizes. Only necessary in the control chart with exact
(probability) limits.}
}
\value{
Return a S control chart.
}
\description{
This function builds a S control chart.
}
\details{
The exact limits are the alpha/2 and 1-alpha/2 quantiles of the S
distribution which is proportional to the square root of a chi-square
distribution.
}
\examples{

data(softdrink)
#S chart with normalized probability limits
cchart.S(softdrink, type = "n")
#S chart with exact probability limits
cchart.S(softdrink, type = "e", 10)

}
\author{
Daniela R. Recchia, Emanuel P. Barbosa
}
