% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_overview.R
\name{item_overview}
\alias{item_overview}
\title{Item Overview}
\usage{
item_overview(
  data,
  tests = "all",
  facets = "all",
  squared = TRUE,
  file_name = "none",
  dpi = 500,
  color = NULL,
  font = "sans",
  size_font = 1,
  wrap = 1,
  width = 1,
  height = 1
)
}
\arguments{
\item{data}{Object of class IPV as created by the function 'ipv_est'}

\item{tests}{character; vector of tests to be included in the overview;
defaults to 'all', in which case all are displayed}

\item{facets}{character; vector of facets to be included in the overview;
defaults to 'all', in which case all are displayed}

\item{squared}{logical; should factor loadings be squared?; defaults to TRUE}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to
"none".}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color}{character; vector of hex codes for colors; defaults to the
colors "#DAD8D8" (gray), "#11C1FF" (light blue), and "#007AD6" (blue)}

\item{font}{character; font of the plot labels; defaults to "sans"}

\item{size_font}{integer; size of the fonts relative to default; defaults to
1}

\item{wrap}{integer; number of rows of plots per facet; defaults to 1}

\item{width}{integer; factor to scale the overall width of the file with; defaults to 1}

\item{height}{integer; factor to scale the overall height of the file with; defaults to 1}
}
\value{
gg / ggplot object; plot grid with one bar plot per item showing
  (squared) factor loadings of that item in all IPV models, arranged by
  facets and tests
}
\description{
Shows all (squared) factor loadings of all items in all models in a plot grid
of bar plots.
}
\details{
File output produces much more reliable results than display within
  R. Display within R may scatter elements of the chart and distort the
  overall appearance.
}
\examples{
# Honesty/Humility and Agreeableness items
# the use of file output is recommended
# to prevent irregular placement of plot labels
# Estimation takes some time.
\dontrun{res <- ipv_est(
  HEXACO[ ,grep("^H|^A", names(HEXACO))],
  "HA")
item_overview(res)} # file output is recommended (see details)


}
