% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCV.R
\name{GCV}
\alias{GCV}
\title{Generalized Cross-Validation}
\usage{
GCV(model)
}
\arguments{
\item{model}{a "lm" or "glm" object}
}
\value{
GCV measurement of the model
}
\description{
Calculates Generalized Cross-Validation (GCV) for "lm" and "glm" objects.
}
\details{
GCV (Koc and Bozdogan, 2015) is calculated as

\deqn{RSS/(n(1 - k/n))}

RSS is the residual sum of squares.
}
\examples{
x1 <- rnorm(100, 3, 2)
x2 <- rnorm(100, 5, 3)
x3 <- rnorm(100, 67, 5)
err <- rnorm(100, 0, 4)

## round so we can use it for Poisson regression
y <- round(3 + 2*x1 - 5*x2 + 8*x3 + err)

m1 <- lm(y~x1 + x2 + x3)
m2 <- glm(y~x1 + x2 + x3, family = "gaussian")
m3 <- glm(y~x1 + x2 + x3, family = "poisson")

GCV(m1)
GCV(m2)
GCV(m3)

}
\references{
Koc, E. K., & Bozdogan, H. (2015). Model selection in multivariate adaptive regression splines (MARS) using information complexity as the fitness function. Machine Learning, 101(1), 35-58.
}
