% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{Metropolis_OAAT_jump}
\alias{Metropolis_OAAT_jump}
\title{One-At-A-Time Metropolis sampler}
\usage{
Metropolis_OAAT_jump(f, x0, fx0, sdjump, ...)
}
\arguments{
\item{f}{function, log-pdf of the target distribution}

\item{x0}{numeric vector, starting point}

\item{fx0}{numeric, f(x0)}

\item{sdjump}{numeric vector, standard deviation of the Gaussian jump for each component}

\item{...}{other arguments passed to f}
}
\value{
A list with the following components:
    \item{x}{numeric vector, updated point after the iteration}
    \item{fx}{numeric, updated value f(x)}
    \item{move}{logical vector, TRUE for components of the vector x that changed}
}
\description{
Performs a single iteration of the OAAT Metropolis sampler
(simulated vector is updated one component at a time).
 a.k.a block Metropolis sampler with blocks of length one.
 Sometimes also called 'Metropolis-within-Gibbs'.
}
\examples{
# Bivariate target distribution: beta(2,10) X exp(1)
f=function(x){stats::dbeta(x[1],2,10,log=TRUE)+stats::dexp(x[2],log=TRUE)}
x0=c(0.5,0.5)
fx0=f(x0)
sdjump=c(0.1,0.1)
Metropolis_OAAT_jump(f,x0,fx0,sdjump)
}
