% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc_precondition_data.R
\name{preproc_precondition_data}
\alias{preproc_precondition_data}
\title{Pre-conditions data with time information and n-day moving averages}
\usage{
preproc_precondition_data(
  data = NULL,
  Date,
  value,
  date_format = "\%Y-\%m-\%d",
  fill_daily = TRUE
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'Date' or 'character' vector when \code{data = NULL}, or 'character' string identifying
Date column name when \code{data} is specified. Dates associated with each value in \code{value}
parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying year column
name when \code{data} is specified. Values to precondition and calculate n-day moving averages
from. N-day moving averages only calculated for daily data.}

\item{date_format}{'character' string. Format of \code{Date}. Default is \code{"\%Y-\%m-\%d"}.}

\item{fill_daily}{'logical' value. Should gaps in \code{Date} and \code{value} be filled using \cr
\code{\link{preproc_fill_daily}}. Default is \code{TRUE}.}
}
\value{
A data.frame with Date, value, and additional columns with time and n-day moving average
information.
}
\description{
Pre-conditions data with time information and n-day moving averages, with options
to fill missing days with \code{NA} values.
}
\details{
These columns are added to the data:
\describe{
\item{\code{year}}{}
\item{\code{month}}{}
\item{\code{day}}{}
\item{\code{decimal_date}}{}
\item{\code{WY}}{Water Year: October 1 to September 30}
\item{\code{CY}}{Climate Year: April 1 to March 30}
\item{\code{Q3}}{3-Day Moving Average: computed at end of moving interval}
\item{\code{Q7}}{7-Day Moving Average: computed at end of moving interval}
\item{\code{Q30}}{30-Day Moving Average: computed at end of moving interval}
\item{\code{jd}}{Julian date}
}

This function also checks the time step of the data to make sure that it is daily time step. Daily
values with gaps are important to fill with \code{NA} to ensure proper calculation of n-day moving
averages. Use \code{fill_daily = TRUE} or \code{\link{preproc_fill_daily}}. Other time steps are currently not
supported and will return the data.frame without moving averages computed.
}
\examples{
preproc_precondition_data(data = example_obs, Date = "Date", value = "streamflow_cfs")

}
\seealso{
\code{\link{preproc_fill_daily}}, \code{\link[zoo]{rollmean}}
}
\keyword{preprocessing-data}
