% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_williamson.R
\name{cdn_williamson}
\alias{cdn_williamson}
\title{cdn_williamson}
\source{
The Williamson sequences were obtained from \href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos} and London (2013).
}
\usage{
cdn_williamson(order)
}
\arguments{
\item{order}{integer}
}
\value{
5 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using available Williamson sequences.
}
\details{
This function checks whether the Hadamard matrix of given order can be constructed using williamson sequences.
If Williamson sequences of length n,n,n,n are available, Hadamard matrix of order 4n can be constructed.
Returns the value 5, if it is possible otherwise NULL is returned.

Williamson sequences are available for length of seq(1,63, 2) except 15, 35, 47, 53, 59 in the internal table.
}
\examples{
cdn_williamson(20)
#5
cdn_goethals_T(24)
#NULL

}
\references{
Williamson, J. (1944). Hadamard determinant theorem and the sum of four squares. Duke. Math. J., 11, 65-81.

Williamson, J. (1947). Note on Hadamard's determnant theorem. Bull. Amer. Math. Soc., 53, 608-613.

London, S. 2013. Constructing New Turyn Type Sequences, T-Sequences and Hadamard Matrices. PhD Thesis, University of Illinois at Chicago, Chicago.
}
\seealso{
\code{\link{had_williamson}} for Williamson construction method using Williamson sequences.
}
