\name{confintHMM}
\alias{confintHMM}
\title{Bootstrap Confidence Intervals for Hidden Markov Models}
\description{
Computes bootstrap confidence intervals for the parameters of a fitted Hidden Markov Model (HMM). The function resamples data by simulating from the fitted model, refits the HMM repeatedly to the simulated data, and constructs confidence intervals for the state-dependent parameters and the transition probability matrix.
}
\usage{
confintHMM(x, HMM, obsdist, level = 0.95, B = 100, EM = FALSE,
           verbose = TRUE, seed = NULL, ...)
}
\arguments{
\item{x}{Numeric vector. The observed data sequence.}
\item{HMM}{A list containing estimated HMM parameters, typically returned by \code{\link{findmleHMM}}. Must include \code{estimate$Pi}, \code{estimate$delta}, and state-dependent observation parameters.}
\item{obsdist}{Character string. Observation distribution. Supported distributions:
"norm", "pois", "weibull", "zip", "nbinom", "zinb", "exp", "gamma", "lnorm", "gev", "ZInormal", "ZIgamma".}
\item{level}{Numeric. Confidence level for the intervals. Default is \code{0.95}.}
\item{B}{Integer. Number of bootstrap replicates to perform. Default is \code{100}.}
\item{EM}{Logical. Whether to use the EM algorithm during refitting. Default is \code{FALSE}.}
\item{verbose}{Logical. If \code{TRUE}, progress messages are printed to the console. Default is \code{TRUE}.}
\item{seed}{Integer or \code{NULL}. Random seed for reproducibility. Default is \code{NULL}.}
\item{...}{Any other parameters that may need to be passed to \code{\link{findmleHMM}}, for example \code{tol} or \code{maxiter}.}
}
\value{
A list with three elements:
\item{obspar_CI}{A data frame with columns:
  \code{Parameter}, \code{Estimate}, \code{Lower}, and \code{Upper}, giving bootstrap confidence intervals for the observation distribution parameters.}
\item{Pi_CI}{A list containing:
  \code{Estimate}, the estimated transition matrix from the fitted model;
  \code{Lower}, the lower bounds of the bootstrap confidence intervals for each transition probability;
  \code{Upper}, the corresponding upper bounds.}
\item{bootstrap_samples}{A list containing:
  \code{obspar}, matrix of bootstrap samples for observation parameters;
  \code{Pi}, array of bootstrap samples for transition matrix;
  \code{n_successful}, number of successful bootstrap iterations;
  \code{n_attempts}, total number of attempts made.}
}
\details{
The function uses a parametric bootstrap procedure. Data are simulated from the fitted HMM using \code{\link{generateHMM}}, and parameters are re-estimated with \code{\link{findmleHMM}}. Confidence intervals are then obtained from the empirical quantiles of the bootstrap replicates.
When \code{verbose = TRUE}, the function reports progress. The function will stop if too many failed bootstrap attempts occur.
}
\examples{
J <- 2
Pi <- matrix(c(0.9, 0.1,
               0.2, 0.8), nrow = 2, byrow = TRUE)
obspar <- list(lambda = c(2, 7))
sim_data <- generateHMM(n = 1000, J = J, obsdist = "pois", obspar = obspar, Pi = Pi)
HMM_fit <- findmleHMM(J = J, x = sim_data$x, obsdist = "pois",
                      obspar = obspar, Pi = Pi, EM = FALSE)
\donttest{
ci <- confintHMM(x = sim_data$x, HMM = HMM_fit, obsdist = "pois",
                 B = 50, level = 0.9)
ci$obspar_CI
ci$Pi_CI
ci_silent <- confintHMM(x = sim_data$x, HMM = HMM_fit, obsdist = "pois",
                        B = 50, level = 0.9, verbose = FALSE)
}
}
\seealso{
\code{\link{findmleHMM}}, for estimating HMM parameters from data.
\code{\link{generateHMM}}, for simulating HMM data.
\code{\link{confintHSMM}}, computing bootstrapped confidence intervals for a hidden semi-Markov model.
}
\author{Aimee Cody}
