% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessoryFunctions.R
\name{parseAlignmentHead}
\alias{parseAlignmentHead}
\title{Guides for Parsing the Header Blocks of Alignment Files}
\usage{
parseAlignmentHead(version)
}
\arguments{
\item{version}{A character string of a validated IPD-IMGT/HLA Database release version (e.g., '3.25.0' or '3250').}
}
\value{
Either FALSE if the version is not valid, or two-value numerical vector describing (1) the header line in which alignment version data appears and (2) the length of the character string in that line preceding version data.
}
\description{
Returns a vector describing the location of key information in the header blocks of alignment files.
}
\examples{
parseAlignmentHead("3.25.0")

}
