% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DGP.r
\name{DGP}
\alias{DGP}
\title{Data Generate Process}
\usage{
DGP(n, p, alpha, norm = 0, no = NA, betanui = NULL, model = "gaussian")
}
\arguments{
\item{n}{the sample size.}

\item{p}{the dimension of the covariates.}

\item{alpha}{the coefficients in moving average model}

\item{norm}{the norm of coefficient vector under the alternative hypothesis (norm of \eqn{\beta} or \eqn{\beta^{(2)}}), the default is 0 (the null hypothesis).}

\item{no}{the number of nonzero coefficients under the alternative hypothesis (do not account the number of nuisance parameter). The default is  \code{NA}, which means the data are generated under the null hypothesis.}

\item{betanui}{the vector which denotes the value of the nuisance coefficients. The default is  \code{NULL} which means the global test.}

\item{model}{a character string to describe the model. The default is \code{"gaussian"}, which denotes the linear model.
The other options are \code{"poisson"}, \code{"logistic"}  and \code{"negative_binomial"} models.}
}
\value{
An object of class "DGP" is a list containing the following components:
\item{X}{the design matrix with \eqn{n} rows and \eqn{p} columns,  where \eqn{n} is the sample size and \eqn{p} is the dimension of the covariates.}
\item{Y}{the response with length \eqn{n}}
}
\description{
Generate the covariates and the response for generalized linear models in simulation.
}
\note{
The covariates \eqn{X[i]=(X[i1],X[i2],...,X[ip])} are generated by the moving average model
  \deqn{ X[ij]=\alpha[1]Z[ij]+\alpha[2]Z[i(j+1)]+...+\alpha[T]Z[i(j+T-1)],}
where \eqn{Z[i]=(Z[i1],Z[i2],...,Z[i(p+T-1)])} were generated from the \eqn{p+T-1} dimensional standard normal distribution
}
\examples{
alpha=runif(5,min=0,max=1)
## Example 1: Linear model
## H_0:  \\beta_0=0
DGP_0=DGP(80,320,alpha)

## Example 2: Logistic model
## H_0:  \\beta_0=0
DGP_0=DGP(80,320,alpha,model="logistic")

## Example 3:  Linear model with the first five coefficients to be nonzero,
## the square of the norm of the coefficients to be 0.2
DGP_0=DGP(80,320,alpha,sqrt(0.2),5)
}
\author{
Bin Guo
}
\references{
Guo, B. and Chen, S. X. (2015). Tests for High Dimensional Generalized Linear Models.
}
\seealso{
\code{\link{HDGLM_test}}
}

