% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESAC.R
\name{ESAC_calibrate}
\alias{ESAC_calibrate}
\title{Generates empirical penalty function \eqn{\gamma(t)} for the ESAC algorithm using Monte Carlo simulation}
\usage{
ESAC_calibrate(
  n,
  p,
  alpha = 1.5,
  K = 5,
  N = 1000,
  tol = 0.001,
  bonferroni = TRUE,
  fast = FALSE,
  rescale_variance = TRUE,
  tdf = NULL,
  debug = FALSE
)
}
\arguments{
\item{n}{Number of observations}

\item{p}{Number time series}

\item{alpha}{Parameter for generating seeded intervals}

\item{K}{Parameter for generating seeded intervals}

\item{N}{Number of Monte Carlo samples used}

\item{tol}{False error probability tolerance}

\item{bonferroni}{If \code{TRUE}, a Bonferroni correction applied and the empirical penalty function \eqn{\gamma(t)} is chosen by simulating leading constants of \eqn{r(t)} through Monte Carlo simulation.}

\item{fast}{If \code{TRUE}, ESAC only tests for a change-point at the midpoint of each seeded interval}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{tdf}{If NULL, samples are drawn from a Gaussian distribution. Otherwise, they are drawn from a \eqn{t}
distribution with \code{tdf} degrees of freedom.}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
A list containing 
  \item{without_partial}{ a vector of values of \eqn{\gamma(t)} for \eqn{t \in \mathcal{T}} decreasing in \eqn{t}}
  \item{with_partial}{same as \code{without_partial}}
  \item{as}{vector of threshold values \eqn{a(t)} for \eqn{t \in \mathcal{T}} decreasing in \eqn{t}}
  \item{nu_as}{vector of conditional expectations \eqn{\nu_{a(t)}} of a thresholded Gaussian, for \eqn{t \in \mathcal{T}} decreasing in \eqn{t}}#'
}
\description{
R wrapper for C function choosing the penalty function \eqn{\gamma(t)} by Monte Carlo simulation, as described in Appendix B in \insertCite{moen2023efficient;textual}{HDCD}.
}
\examples{
library(HDCD)
n = 50
p = 50

set.seed(100)
thresholds_emp = ESAC_calibrate(n,p, N=100, tol=1/100)
set.seed(100)
thresholds_emp_without_bonferroni = ESAC_calibrate(n,p, N=100, tol=1/100,bonferroni=FALSE)
thresholds_emp[[1]] # vector of \gamma(t) for t = p,...,1
thresholds_emp_without_bonferroni[[1]] # vector of \gamma(t) for t = p,...,1

# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# Adding a single sparse change-point:
X[1:5, 26:n] = X[1:5, 26:n] +2

res = ESAC(X, thresholds_test = thresholds_emp[[1]])
res$changepoints
}
\references{
\insertAllCited{}
}
