% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{TraceRatio}
\alias{TraceRatio}
\title{Trace Ratio}
\usage{
TraceRatio(G, Ghat)
}
\arguments{
\item{G}{The true factors matrix.}

\item{Ghat}{The estimated factors matrix.}
}
\value{
A numeric value representing the trace ratio, defined as:
\eqn{\mathrm{TR} = \mathrm{tr} ( \mathbf{G}' \widehat{\mathbf{G}} (\widehat{\mathbf{G}}'\widehat{\mathbf{G}})^{-1} \widehat{\mathbf{G}}'\mathbf{G})/\mathrm{tr}(\mathbf{G'G})}.
}
\description{
Evaluation of the estimated factors by trace ratios. The value is between 0 and 1; higher values indicate better estimation accuracy.
}
\examples{
G <- matrix(rnorm(100 * 2), 100, 2)
Ghat <- G + matrix(rnorm(100 * 2, sd = 0.1), 100, 2)
TraceRatio(G, Ghat)

}
