% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searcher_efficiency_functions.R
\name{aicc.pkmSize}
\alias{aicc.pkmSize}
\title{Create the AICc tables for a list of sets of searcher efficiency models}
\usage{
\method{aicc}{pkmSize}(x, ...)
}
\arguments{
\item{x}{List of set of searcher efficiency models fit to the same
observations}

\item{...}{further arguments passed to or from other methods}
}
\value{
AICc table
}
\description{
Generates model comparison tables based on AICc values for
  a set of pk models generated by \code{\link{pkm}} with
  \code{allCombos = FALSE} and a non-\code{NULL} \code{sizeCol}.
}
\examples{
  data(wind_RP)
  mod <- pkmSet(formula_p = p ~ Season, formula_k = k ~ Season, data = wind_RP$SE)
 aicc(mod)

}
