% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.statistics.R
\name{graph.statistics}
\alias{graph.statistics}
\title{Statistics for edges (lines)}
\usage{
graph.statistics(x, r, stats = c("min", "mean", "max"), buffer = NULL)
}
\arguments{
\item{x}{sp SpatialLinesDataFrame or sf LINE object}

\item{r}{A terra SpatRast or raster rasterLayer, rasterStack, rasterBrick object}

\item{stats}{Statistics to calculate. If vectorized, can pass a custom 
statistic function.}

\item{buffer}{Buffer distance, radius in projection units. For statistics 
based on edge buffer distance}
}
\value{
data.frame object of statistics
}
\description{
Extracts raster values for each edge and calculates specified statistics
}
\note{
If the buffer argument is specified that, raster values within the specified 
buffer radius are extracted and included in the derived statistic(s). Else-wise,
the statistics are derived from raster values that directly intersect each edge.
}
\examples{
\donttest{
 library(sf)
 library(terra)  

 data(ralu.site)	
 xvars <- rast(system.file("extdata/covariates.tif", package="GeNetIt"))
 
  ( dist.graph <- knn.graph(ralu.site, row.names = ralu.site$SiteName, 
                            max.dist = 1500) )
 
 skew <- function(x, na.rm = TRUE) {  
           if (na.rm) x <- x[!is.na(x)]
           sum( (x - mean(x)) ^ 3) / ( length(x) * sd(x) ^ 3 )  
 		}

# Moments on continuous raster data
 system.time( {		
  stats <- graph.statistics(dist.graph, r = xvars[[-6]],  
              stats = c("min", "median", "max", "var", "skew")) 
 } ) 

# Proportional function on nominal raster data		
p <- function(x) { length(x[x < 52]) / length(x) }	
	
  system.time( {		
   nstats <- graph.statistics(dist.graph, r = xvars[[6]],
               stats = "p") 
  } ) 	

# Based on 500m buffer distance around line(s)
 system.time( {		
  stats <- graph.statistics(dist.graph, r = xvars[[-6]],  
              stats = c("min", "median", "max", "var", "skew"),
			      buffer = 500) 
 } )

}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie A. Murphy <melanie.murphy@uwyo.edu>
}
