% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compbypath.R
\name{compbypath}
\alias{compbypath}
\title{Basic description}
\usage{
compbypath(G,re.path)
}
\arguments{
\item{G}{a list of all groups}

\item{re.path}{the shortest Hamiltonian path returned from the function Hpath}
}
\value{
the number of edges that connect nodes between samples
}
\description{
Given the groups and the shortest Hamiltonian path, this function returns the number of edges that connect nodes between samples.
}
\examples{
d=100;n1=20;n2=30;n3=40;
N=n1+n2+n3
mu1=rep(0,d)
mu2=mu1
mu3=mu2+0.1
cov1=0.2^(abs(outer(1:d,1:d,"-")))
cov2=0.2^(abs(outer(1:d,1:d,"-")))
cov3=0.4^(abs(outer(1:d,1:d,"-")))
sam1=MASS::mvrnorm(n=n1,mu=mu1,Sigma=cov1)
sam2=MASS::mvrnorm(n=n2,mu=mu2,Sigma=cov2)
sam3=MASS::mvrnorm(n=n3,mu=mu3,Sigma=cov3)
Data=rbind(sam1,sam2,sam3)
Dist=philentropy::distance(Data, method = "euclidean")
Dist[lower.tri(Dist)] <- NA
Dist[diag(Dist)] <- NA
G=list()
G[[1]]=c(1:n1);G[[2]]=c((n1+1):(n1+n2));G[[3]]=c((n1+n2+1):(n1+n2+n3));
compbypath(G,Hpath(1,N,Dist))
}
\seealso{
Hpath
}
