% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testP.R
\name{testP}
\alias{testP}
\title{Periodic solution test}
\usage{
testP(data, wthresh = 0.1, fxPtThresh = 1e-04, show = 0)
}
\arguments{
\item{data}{Input Time series: Each column is one time series
that corresponds to one variable.}

\item{wthresh}{Threshold used to detect the limit cycle.}

\item{fxPtThresh}{Threshold used to detect fixed points.}

\item{show}{Provide (2) or not (0-1) visual output during
the running process.}
}
\value{
\code{periodic}  An integer classifying the models:
diverging or unclassified trajectory (0),
period-1 trajectory (-1), period-2 trajectory (-2)
and fixed Point (2).
}
\description{
Tests if a trajectory is periodic.
}
\examples{
#Example
# Load data:
data('P1FxChP2')
# Test a period-1 trajectory
testP(P1FxChP2[,1:2], wthresh=0.1, fxPtThresh = 1e-6, show=0)
# Test a Fixed Point trajectory
testP(P1FxChP2[,3:4], wthresh=0.1, fxPtThresh = 1e-6, show=0)
# Test a chaotic trajectory
testP(P1FxChP2[,5:6], wthresh=0.1, fxPtThresh = 1e-6, show=0)
# Test a period-2 trajectory
testP(P1FxChP2[,7:8], wthresh=0.1, fxPtThresh = 1e-6, show=0)

}
\seealso{
\code{\link{autoGPoMoTest}}, \code{\link{gPoMo}}
}
\author{
Sylvain Mangiarotti, Flavie Le Jean
}
