% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEpost.R
\name{EEpost}
\alias{EEpost}
\title{Post-processing step for edge-exploited graph matching.}
\usage{
EEpost(W = NULL, A, B, rep, tau = NULL, d = NULL, matching = NULL)
}
\arguments{
\item{W}{A distance matrix.}

\item{A, B}{Two 0/1 adjacency matrices.}

\item{rep}{A positive integer, indicating the number of iterations.}

\item{tau}{A positive threshold. The default value is \eqn{rep/10}.}

\item{d}{A positive integer, indicating the number of candidate matching. The
default value is 1.}

\item{matching}{A preliminary matching result for \emph{EEpost}. If
\code{matching} is null, \emph{EEpost} will apply \emph{DPedge} accordingly
to generate the initial matching.}
}
\value{
\item{Dist}{The distance matrix between two graphs.} \item{match}{A
  vector containing matching results.} \item{FLAG}{An indicator vector
  indicating whether the matching result is converged. 0 for No and 1 for
  Yes.} \item{converged.match}{Converged match result. \code{NA} indicates
  the matching result for a certain node is not v=convergent.}
  \item{converged.size}{The number of converged nodes.}
}
\description{
Funtions \emph{DPmatching} or \emph{DPedge} can produce a
  preliminary graph matching result. This function, \emph{EEPost} works on
  refining the result iteratively. In addition, \emph{EEpost} is able to
  provide a convergence indicator vector \emph{FLAG} for each matching as a
  reference for the certainty about the matching since in practice,it has
  been observed that the true matches usually reach the convergence and stay
  the same after a few iterations, while the false matches may keep changing
  in the iterations.
}
\details{
Similar to function \emph{EEpre}, \emph{EEpost} uses maximum
  bipartite matching to maximize the number of common neighbours for the
  matched vertices with the knowledge of a preliminary matching result by
  defining the similarity between \eqn{i \in A} and \eqn{j \in B} as the
  number of common neighbours between \eqn{i} and \eqn{j} according to the
  preliminary matching. Then, given a matching result \eqn{\Pi_t}, post
  processing step is to seek a refinement \eqn{\Pi_{t+1}} satisfying
  \eqn{\Pi_{t+1} \in} argmax \eqn{\langle \Pi, A \Pi_t B \rangle}, where
  \eqn{\Pi} is a permutation matrix of dimension \eqn{(n_A, n_B)}.
}
\examples{
set.seed(2020)
n = 10;p = 1; q = 1/2; s = 1
Parent = matrix(rbinom(n*n, 1, q), nrow = n, ncol = n)
Parent[lower.tri(Parent)] = t(Parent)[lower.tri(Parent)]
diag(Parent) <- 0
### Generate graph A
dA = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n)
dA[lower.tri(dA)] = t(dA)[lower.tri(dA)]
A1 = Parent*dA;
tmp = rbinom(n, 1, p)
n.A = length(which(tmp == 1))
indA = sample(1:n, n.A, replace = FALSE)
A = A1[indA, indA]
### Generate graph B
dB = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n)
dB[lower.tri(dB)] = t(dB)[lower.tri(dB)]
B1 = Parent*dB
tmp = rbinom(n, 1, p)
n.B = length(which(tmp == 1))
indB = sample(1:n, n.B, replace = FALSE)
B = B1[indB, indB]
matching1= DPmatching(A, B)$Dist
EEpost(A = A, B = B, rep = 10, d = 5)
EEpost(A = A, B = B, rep = 10, d = 5, matching = matching1)

}
