% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortest_path_igraph.R
\encoding{UTF-8}
\name{shortest_path_igraph}
\alias{shortest_path_igraph}
\title{Shortest path (igraph)}
\usage{
shortest_path_igraph(
  from_node_ID,
  to_node_ID,
  graph_object = graph,
  unit = "minutes",
  path = FALSE
)
}
\arguments{
\item{from_node_ID}{Numeric value with the from node ID (if multiple node ID’s are to be used, see the function \code{\link[=shortest_path_cppRouting]{shortest_path_cppRouting()}}).}

\item{to_node_ID}{Numeric value with the to node ID (if multiple node ID’s are to be used, see the function \code{\link[=shortest_path_cppRouting]{shortest_path_cppRouting()}}).}

\item{graph_object}{The road network structured as a tidy graph (\code{tbl_graph} object). This can be created with the function \code{\link[=vegnett_to_R]{vegnett_to_R()}}.}

\item{unit}{Character vector with \code{minutes} to calculate the shortest path in minutes or \code{meters} for the shortest path in meters.}

\item{path}{Logical. If \code{TRUE} the node link with the shortest path is returned.}
}
\value{
Vector with the shortest path in minutes or meters. If \code{path = TRUE} the node link that the shortest path consists of is returned.
}
\description{
The function \code{shortest_path_igraph} can be used to calculate the shortest path (either in minutes or meters) between nodes in the Norwegian road network. The function can also return the node link, i.e. path, that the shortest path consists of.
}
\details{
Before the function can be used, the road network must be converted to a \code{tbl_graph} object. This can be done with the function \code{\link[=vegnett_to_R]{vegnett_to_R()}}). There objects \code{graph} and \code{edges} needs to be loaded.
}
\examples{
shortest_path_igraph(from_node_ID = 25,
                     to_node_ID = 33,
                     unit = "minutes",
                     graph_object = graph_sampledata)

shortest_path_igraph(from_node_ID = 25,
                     to_node_ID = 33,
                     unit = "meters",
                     graph_object = graph_sampledata)

shortest_path_igraph(from_node_ID = 25,
                     to_node_ID = 33,
                     unit = "minutes",
                     path = TRUE,
                     graph_object = graph_sampledata)

}
