% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{plot.combined_global_envelope2d}
\alias{plot.combined_global_envelope2d}
\title{Plotting function for combined 2d global envelopes}
\usage{
\method{plot}{combined_global_envelope2d}(
  x,
  fixedscales = 2,
  labels,
  what = c("obs.sign", "obs", "lo", "hi", "lo.sign", "hi.sign"),
  sign.type = c("circles", "contour", "col"),
  sign.col = c("blue", "red"),
  transparency = 155/255,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A 'global_envelope' object for two-dimensional functions}

\item{fixedscales}{0, 1 or 2. See details.}

\item{labels}{A character vector of suitable length giving the labels for the separate plots.
Default exists. This parameter allows replacing the default.}

\item{what}{Character vector specifying what information should be plotted for 2d functions.
A combination of:
Observed (\code{"obs"}), upper envelope (\code{"hi"}), lower envelope (\code{"lo"}),
observed with significantly higher values highlighted (\code{"hi.sign"}),
observed with significantly lower values highlighted (\code{"lo.sign"}),
observed with significantly (lower and higher) values highlighted (\code{"obs.sign"}).
Default to the last one. Combination c("obs", "lo", "hi", "lo.sign", "hi.sign") can
also be of interest (earlier default).}

\item{sign.type}{Either \code{"col"} for color showing the significant region, or
\code{"contour"} for colored contour showing the significant region, or
\code{"circles"} for plotting circles at locations where the observed function
exceeds the envelope: diameters proportional to (obs-hi)/(hi-lo) for values
above the envelope and (lo-obs)/(hi-lo) for values below the envelope.
In the one-sided (testing) case, the divisors are instead (hi-central) (case 'greater')
and (central-lo) (case 'less').
Default to \code{"circles"}.}

\item{sign.col}{A vector of length two giving the colors for significant parts
below the envelope (first value) and above the envelope (second value).}

\item{transparency}{A number between 0 and 1 (default 155/255, 60% transparency).
Similar to alpha of \code{\link[grDevices]{rgb}}. Used in plotting the significant regions for 2d
functions.}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{...}{Ignored.}
}
\description{
If fixedscales is FALSE (or 0) all images will have separate scale.
If fixedscales is TRUE (or 1) each x[[i]] will have a common scale.
If fixedscales is 2 all images will have common scale.

If more than one envelope has been calculated (corresponding to several coverage/alpha),
only the largest one is plotted.
}
\examples{
data("abide_9002_23")
iset <- subset(abide_9002_23[['curve_set']], 1:50)
factors <- abide_9002_23[['factors']][1:50,]
\dontshow{
# Cut the data to reduce time
iset$r <- iset$r[1:7,]
iset$funcs <- iset$funcs[1:7, ]
}
res <- graph.flm(nsim = 19, # Increase nsim for serious analysis!
  formula.full = Y ~ Group + Sex + Age,
  formula.reduced = Y ~ Sex + Age,
  curve_sets = list(Y=iset), factors = factors,
  contrasts = FALSE, GET.args = list(type="area"))
plot(res)
\donttest{
plot(res, what=c("obs", "hi"))

plot(res, what=c("hi", "lo"), fixedscales=1)

plot(res, what=c("obs", "lo", "hi"), fixedscales=FALSE)

if(requireNamespace("gridExtra", quietly=TRUE)) {
  # Edit style of "fixedscales = 2" plots
  plot(res, what=c("obs", "hi")) + ggplot2::theme_minimal()
  plot(res, what=c("obs", "hi")) + ggplot2::theme_bw()

  # Edit style (e.g. theme) of "fixedscales = 1 or 0" plots
  gs <- lapply(res, function(x, what) { plot(x, what=what) +
     ggplot2::ggtitle("") }, what=c("obs", "hi"))
  gridExtra::grid.arrange(grobs=gs, ncol=1, top="My main")

  gs <- outer(res, c("obs", "hi"), FUN=Vectorize(function(res, what)
    list(plot(res, what=what) + ggplot2::ggtitle("") +
      ggplot2::theme(axis.ticks=ggplot2::element_blank(),
      axis.text=ggplot2::element_blank(), axis.title=ggplot2::element_blank()))))
  gridExtra::grid.arrange(grobs=t(gs))
}
}
}
