% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_hotspots.r
\name{MatClust.lppm}
\alias{MatClust.lppm}
\title{Fit a Matern cluster point process to a point pattern dataset on a linear network}
\usage{
MatClust.lppm(
  PP,
  formula,
  subwin = NULL,
  valpha,
  vR,
  data,
  nsim = 10,
  ncores = 1L
)
}
\arguments{
\item{PP}{Input, a point pattern object (ppp) of spatstat.}

\item{formula}{An R formula to estimate the first order model.
This formula can contain objects of full size. \code{PP} should be on the
left side of the formula.}

\item{subwin}{A part of the observation window of \code{PP} to be used for
estimating the second order structure. NULL means that the full point pattern
is used. Typically this is feasible (not too time consuming).}

\item{valpha}{A vector of parameter values for the parameter alpha of the
Matern cluster process.}

\item{vR}{A vector of parameter values for the parameter R of the Matern
cluster process.}

\item{data}{Data from where the formula takes objects.
Must be acceptable by the function lppm of spatstat.linnet.}

\item{nsim}{The number of simulated Matern cluster point patterns for
evaluating the K-function for any alpha and R values.}

\item{ncores}{Number of cores used for computations. Default to 1.
If NULL, all available cores are used.}
}
\description{
Fit a Matern cluster point process to a point pattern dataset on a linear network.
This function is provided in \pkg{GET} to support
\code{\link{hotspots.MatClustlpp}}. See the hotspots vignette available
by starting R, typing \code{library("GET")} and \code{vignette("GET")}.
}
\details{
The function \code{MatClust.lppm}, can be used to estimate the Matern
cluster point pattern with inhomogeneous cluster centers on linear network.
This function provides the same outputs as the \code{\link{pois.lppm}} and
further estimated parameters \code{alpha} and \code{R}. The \code{secondorder}
provides again the diagnostics for checking if the clustered model is
appropriate. The sample K-function must be close to the K-function of the
estimated model (green line). If it is not the case the searching grid for
parameters \code{alpha} and \code{R} that is input in the function must be
manipulated to get the a closer result. If the estimated model is adequate
one can proceed to the hotspot detection with the use of the function
\code{\link{hotspots.MatClustlpp}}. Remark here, that for the estimation of
the second order structure a smaller data can be used than for the estimation
of the first order structure in order to save the computation time, since the
second order is a local characteristics. This smaller window can be specified
by \code{subwin}. Then the full point pattern will be used for estimation of
first order intensity and the pattern in subwindow will be used for estimating
second order characteristic. The input parameters are the same as in
\code{\link{pois.lppm}}. Furthermore, \code{valpha}, i.e., vector of proposed
alphas which should be considered in the optimization, \code{vR}, i.e., vector
of proposed values for R which should be considered in the optimization, must
be provided. The user can also specify how many cores should be used in the
computation by parameter \code{ncores}.
}
