anova_test_univariate <- function(X, Y, k_n){
  n = length(X)
  xi = Y
  xi = xi[order(X)]

  V = matrix(0, n-k_n+1, k_n)
  for(ind in ((k_n+1)/2):(n-(k_n+1)/2+1))
    V[ind-(k_n+1)/2+1,] = xi[(ind-(k_n+1)/2+1):(ind+(k_n+1)/2-1)]

  nv = dim(V)[1]
  t_mean = mean(V)

  MST = sum((rowMeans(V) - t_mean)^2)*k_n/(nv-1)
  MSE = sum((V - rowMeans(V))^2)/(nv*k_n - nv)

  tau = sum((xi[2:n] - xi[1:(n-1)])^2)/(2*(n-1))


  if(tau == 0 || is.na(tau)){
    tau = 0.0000000000001
  } # End if
  p_value = (1-pnorm((sqrt(nv/k_n)*(MST-MSE))/(sqrt(4*tau^2/3))))
  return(p_value)
} # End anova_test_univariate
