% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snk.test.R
\name{snk.test}
\alias{snk.test}
\title{Student-Newman-Keuls (SNK) procedure}
\usage{
snk.test(object, term = NULL, among = NULL, within = NULL, anova.tab = NULL)
}
\arguments{
\item{object}{an object of class "\code{\link{lm}}" containing the specified design.}

\item{term}{term of the model to be analysed. Argument \code{term} can be a main effect, an interaction or a nested factor, which must be specified using "quotes". Use \code{\link{estimates}} to see the right form to inform it. See examples below.}

\item{among}{specifies the factor which levels will be compared among. Need to be specified if the term to be analysed envolves more than one factor.}

\item{within}{specifies the factor or combination of factors that will be compared within level among.}

\item{anova.tab}{an object containing the results returned by \code{\link{gad}} or \code{\link{pooling}} functions. See examples below.}
}
\value{
A list containing the standard error, the degrees of freedom and pairwise comparisons among levels of one factor within each level of other(s) factor(s).
}
\description{
This function performs a SNK post-hoc test of means on the factors of a chosen term of the model, comparing among levels of one factor within each level of other factor or combination of factors.
}
\details{
SNK is a stepwise procedure for hypothesis testing. First the sample means are sorted, then the pairwise studentized range (q) is calculated by dividing the differences between means by the standard error, which is based upon the average variance of the two samples.
}
\examples{
library(GAD)

# Example 1
data(rohlf95)
CG <- as.fixed(rohlf95$cages)     # a fixed factor
MQ <- as.random(rohlf95$mosquito) # a random factor nested in cages

model <- lm(wing ~ CG + CG\%in\%MQ, data = rohlf95)
model.tab <- gad(model) # storing ANOVA table in an object
model.tab               # checking ANOVA results
estimates(model)        # checking model structure

# Comparison among levels of mosquito ("MQ") within each level of cage ("CG")
snk.test(model, term = "CG:MQ", among = "CG", within = "MQ", anova.tab = model.tab)

# Example 2
data(snails)
O <- as.random(snails$origin)   # a random factor
S <- as.random(snails$shore)    # a random factor orthogonal to origin
B <- as.random(snails$boulder)  # a random factor nested in shore
C <- as.random(snails$cage)     # a random factor nested in the combination of boulder and origin
model2 <- lm(growth ~ O + S + O*S + B\%in\%S + O*(B\%in\%S) + C\%in\%(O*(B\%in\%S)), data = snails)
model2.tab <- gad(model2, quasi.f = FALSE) # storing ANOVA table in an object
model2.tab                                 # checking ANOVA results
estimates(model2, quasi.f = FALSE)         # checking model structure

# Comparison among levels of "origin"
snk.test(model2, term = "O", anova.tab = model2.tab)
# Comparison among levels of "shore" within each level of "origin"
snk.test(model2, term = "O:S", among = "S", within = "O", anova.tab = model2.tab)
# If term "O:S:B" were significant, we could try
snk.test(model2, term = "O:S:B", among = "B", within = "O:S", anova.tab = model2.tab)
}
\seealso{
\code{\link{gad}}, \code{\link{estimates}}
}
\author{
Maurício Camargo (\email{mauricio.camargo@furg.br})

Eliandro Gilbert (\email{eliandrogilbert@gmail.com})

Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
