% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.fixed.R
\name{is.fixed}
\alias{is.fixed}
\title{Check if a factor is fixed}
\usage{
is.fixed(x)
}
\arguments{
\item{x}{a vector of data, usually a nominal variable encoded as a \code{"fixed factor"} using \code{\link{as.fixed}}.}
}
\value{
Function \code{is.fixed} returns \code{TRUE} or \code{FALSE} depending on whether its argument is a fixed factor or not.
}
\description{
This function works the same way as \code{\link{is.factor}}.
}
\examples{
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
is.fixed(CG)
is.random(MQ)
}
\seealso{
\code{\link{is.random}}, \code{\link{as.fixed}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
