% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{estimates}
\alias{estimates}
\title{Estimates of an analysis of variance design}
\usage{
estimates(object, quasi.f = FALSE)
}
\arguments{
\item{object}{an object of class "\code{\link{lm}}", containing the specified design with random and/or fixed factors.}

\item{quasi.f}{logical, indicating whether to use quasi F-ratio when there is no single error term appropriate in the analysis. Default to \code{FALSE}.}
}
\value{
A list containing the table of multipliers (\code{$tm}), the mean squares estimates (\code{$mse}) and the F-ratio versus (\code{$f.versus}) for the model.
}
\description{
This function is used to construct the mean squares estimates of an ANOVA design, considering the complications imposed by nested/orthogonal and fixed/random factors.
}
\details{
Determines what each mean square estimates in an ANOVA design by a set of procedures originally described by Cornfield and Tukey (1956). This version is a modification proposed by Underwood (1997), which does not allow for the use of fixed nested factors. The steps involve the construction of a table of multipliers with a row for each source of variation and a column for each term in the model that is not an interaction. The mean square estimates for each source of variation is obtained by determining which components belong to each mean square and what is their magnitude. This enables the recognition of appropriate F-ratios.
}
\examples{
# Example 1
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
model <- lm(wing ~ CG + MQ\%in\%CG, data = rohlf95)
estimates(model)

# Example 2
data(rats)
names(rats)
TR <- as.fixed(rats$treat)
RA <- as.random(rats$rat)
LI <- as.random(rats$liver)
model2 <- lm(glycog ~ TR + RA\%in\%TR + LI\%in\%RA\%in\%TR, data = rats)
estimates(model2)

# Example 3
data(snails)
O <- as.random(snails$origin)
S <- as.random(snails$shore)
B <- as.random(snails$boulder)
C <- as.random(snails$cage)
model3 <- lm(growth ~ O + S + O*S + B\%in\%S + O*(B\%in\%S) + C\%in\%(O*(B\%in\%S)), data = snails)
estimates(model3) # 'no test' for shore
estimates(model3, quasi.f = TRUE) # suitable test for shore
}
\references{
Cornfield, J., Tukey, J.W. 1956. Average values of mean squares in factorials. Annals of Mathematical Statistics 27, 907-949.

Underwood, A.J. 1997. \emph{Experiments in Ecology}: Their Logical Design and Interpretation Using Analysis of Variance. Cambridge University Press, Cambridge.
}
\seealso{
\code{\link{gad}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})

Eliandro Gilbert (\email{eliandrogilbert@gmail.com})
}
