% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fixed.R
\name{as.fixed}
\alias{as.fixed}
\title{Encodes a vector as a "fixed factor"}
\usage{
as.fixed(x)
}
\arguments{
\item{x}{a vector of data, usually a nominal variable.}
}
\value{
Function \code{as.fixed} returns an object of class \code{"factor"} and \code{"fixed"}.
}
\description{
Assigns a class \code{"fixed"} to a vector
}
\details{
The function works the same way as \code{\link{as.factor}}, but assigns an additional class informing that it is a fixed factor.
}
\examples{
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
class(CG)
class(MQ)
}
\seealso{
\code{\link{as.random}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
