% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-Arithmetic.R
\docType{methods}
\name{Arithmetic}
\alias{Arithmetic}
\alias{*,numeric,FuzzyNumber-method}
\alias{+,numeric,FuzzyNumber-method}
\alias{-,numeric,FuzzyNumber-method}
\alias{*,TrapezoidalFuzzyNumber,numeric-method}
\alias{+,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}
\alias{-,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}
\alias{-,FuzzyNumber,ANY-method}
\alias{+,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\alias{-,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\alias{*,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\alias{/,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\alias{+,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}
\alias{-,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}
\alias{/,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}
\alias{*,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}
\alias{+,PiecewiseLinearFuzzyNumber,numeric-method}
\alias{-,PiecewiseLinearFuzzyNumber,numeric-method}
\alias{*,PiecewiseLinearFuzzyNumber,numeric-method}
\alias{/,PiecewiseLinearFuzzyNumber,numeric-method}
\title{Arithmetic Operations on Fuzzy Numbers}
\usage{
\S4method{+}{numeric,FuzzyNumber}(e1, e2) # e2 + e1

\S4method{+}{TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber}(e1, e2)

\S4method{+}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)

\S4method{+}{PiecewiseLinearFuzzyNumber,numeric}(e1, e2)

\S4method{+}{PiecewiseLinearFuzzyNumber,FuzzyNumber}(e1, e2) # calls as.PiecewiseLinearFuzzyNumber()

\S4method{-}{numeric,FuzzyNumber}(e1, e2) # e2*(-1) + e1

\S4method{-}{TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber}(e1, e2)

\S4method{-}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)

\S4method{-}{PiecewiseLinearFuzzyNumber,numeric}(e1, e2)

\S4method{-}{PiecewiseLinearFuzzyNumber,FuzzyNumber}(e1, e2) # calls as.PiecewiseLinearFuzzyNumber()

\S4method{-}{FuzzyNumber,ANY}(e1, e2) # -e1

\S4method{*}{numeric,FuzzyNumber}(e1, e2) # e2 * e1

\S4method{*}{TrapezoidalFuzzyNumber,numeric}(e1, e2)

\S4method{*}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)

\S4method{*}{PiecewiseLinearFuzzyNumber,FuzzyNumber}(e1, e2) # calls as.PiecewiseLinearFuzzyNumber()

\S4method{*}{PiecewiseLinearFuzzyNumber,numeric}(e1, e2)

\S4method{/}{PiecewiseLinearFuzzyNumber,numeric}(e1, e2)

\S4method{/}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)

\S4method{/}{PiecewiseLinearFuzzyNumber,FuzzyNumber}(e1, e2) # calls as.PiecewiseLinearFuzzyNumber()
}
\arguments{
\item{e1}{a fuzzy number or single numeric value}

\item{e2}{a fuzzy number or single numeric value}
}
\value{
Returns a fuzzy number of the class \linkS4class{PiecewiseLinearFuzzyNumber}
or \linkS4class{TrapezoidalFuzzyNumber}.
}
\description{
Applies arithmetic operations using the extension principle
and interval-based calculations.
}
\details{
Implemented operators: \code{+}, \code{-}, \code{*}, \code{/}
for piecewise linear fuzzy numbers.
Also some versions may be applied on numeric values and
trapezoidal fuzzy numbers.

Note that according to the theory the class of PLFNs is not closed
under the operations * and /.
However, if you operate on a large number of knots,
the results should be satisfactory.

Thanks to Jan Caha for suggestions on PLFN operations.
}
\seealso{
Other FuzzyNumber-method: 
\code{\link{Extract}},
\code{\link{FuzzyNumber-class}},
\code{\link{FuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{alphacut}()},
\code{\link{ambiguity}()},
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{core}()},
\code{\link{distance}()},
\code{\link{evaluate}()},
\code{\link{expectedInterval}()},
\code{\link{expectedValue}()},
\code{\link{integrateAlpha}()},
\code{\link{piecewiseLinearApproximation}()},
\code{\link{plot}()},
\code{\link{show}()},
\code{\link{supp}()},
\code{\link{trapezoidalApproximation}()},
\code{\link{value}()},
\code{\link{weightedExpectedValue}()},
\code{\link{width}()}

Other PiecewiseLinearFuzzyNumber-method: 
\code{\link{Extract}},
\code{\link{PiecewiseLinearFuzzyNumber-class}},
\code{\link{PiecewiseLinearFuzzyNumber}},
\code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
\code{\link{alphaInterval}()},
\code{\link{arctan2}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()},
\code{\link{fapply}()},
\code{\link{maximum}()},
\code{\link{minimum}()},
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{plot}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}

Other TrapezoidalFuzzyNumber-method: 
\code{\link{TrapezoidalFuzzyNumber-class}},
\code{\link{TrapezoidalFuzzyNumber}},
\code{\link{TriangularFuzzyNumber}()},
\code{\link{alphaInterval}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{expectedInterval}()},
\code{\link{plot}()}

Other extension_principle: 
\code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
\code{\link{fapply}()}
}
\concept{FuzzyNumber-method}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{TrapezoidalFuzzyNumber-method}
\concept{extension_principle}
