% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_center.R
\name{get_center}
\alias{get_center}
\title{Obtaining Center Coordinates of Spatial \code{fe_stand} Child Objects}
\usage{
get_center(x)
}
\arguments{
\item{x}{An object of one of \code{fe_stand}'s child classes that carry
spatial information, i.e. \code{\link{fe_stand_spatial}},
\code{\link{fe_ccircle_spatial}}, \code{\link{fe_ccircle_spatial_notrees}}}
}
\value{
The coordinates of the point that describes best the spatial center
of the object \code{x}. In case of objects of classes
\code{\link{fe_ccircle_spatial}}, and
\code{\link{fe_ccircle_spatial_notrees}}, this is the center of the
concentric circle with the largest area. In case of an
\code{\link{fe_stand_spatial}} object, this is the center of gravity of the
object's polygon outline. The point object returned belongs to a class
provided by the package \code{sf}. The class of that object depends
on how the coordinates are defined in \code{x} (i.e. as an
\code{sfc} or an \code{sfg} object). If \code{x} is unsuitable for
retrieving center coordinates, the function returns an empty geometry.
}
\description{
Obtaining Center Coordinates of Spatial \code{fe_stand} Child Objects
}
\examples{
  spruce_pine_ccircle_spatial_notrees |> get_center()
  spruce_pine_ccircle_spatial_notrees |> get_center()
  mm_forest_1_fe_stand_spatial |> get_center()

  # Unsuitable objects
  get_center(spruce_beech_1_fe_stand)
  get_center("this is a character string")

}
